/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetBuilder;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWDataTableBuilder {
    private String name;
    private DWDataSetBuilder owner;
    private List<Object> deletedOids;
    private static final String ROW_STATE_DEFAULT = "$defaultImportState";
    private Map<String, List<Map<String, Object>>> rowOrgDatas;

    public DWDataTableBuilder() {
    }

    DWDataTableBuilder(DWDataSetBuilder owner) {
        this.owner = owner;
    }

    public DWDataTableBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DWDataSetBuilder getOwner() {
        return this.owner;
    }

    public DWDataTableBuilder addRowOrgDatas(List<Map<String, Object>> rowOrgDatas) {
        String state = ROW_STATE_DEFAULT;
        this.addRowOrgDatas(rowOrgDatas, state);
        return this;
    }

    public DWDataTableBuilder addRowOrgDatas(List<Map<String, Object>> rowOrgDatas, String state) {
        List<Map<String, Object>> stateRowOrgDatas;
        if (state == null) {
            state = "";
        }
        if (this.rowOrgDatas == null) {
            this.rowOrgDatas = new HashMap<String, List<Map<String, Object>>>();
        }
        if ((stateRowOrgDatas = this.rowOrgDatas.get(state)) == null) {
            stateRowOrgDatas = new ArrayList<Map<String, Object>>();
            this.rowOrgDatas.put(state, stateRowOrgDatas);
        }
        stateRowOrgDatas.addAll(rowOrgDatas);
        return this;
    }

    public DWDataTableBuilder setDeletedOids(List<Object> oids) {
        this.deletedOids = oids;
        return this;
    }

    public DWDataTable create() {
        DWDataSet dataset = new DWDataSet();
        DWDataTable dataTable = this.create(dataset);
        return dataTable;
    }

    public DWDataTable create(DWDataSet dataset) {
        DWDataTable dt = dataset.newTable(this.name);
        this.buildDataTable(dt);
        return dt;
    }

    public DWDataSet createDataSet() {
        return this.owner.create();
    }

    private void buildDataTable(DWDataTable dt) {
        this.bildDataTableRows(dt);
        this.buildDataTableDelectionRows(dt);
    }

    private void bildDataTableRows(DWDataTable dt) {
        if (this.rowOrgDatas == null) {
            return;
        }
        for (Map.Entry<String, List<Map<String, Object>>> item : this.rowOrgDatas.entrySet()) {
            String state = item.getKey();
            DWDataRow[] rows = dt.newRows(item.getValue());
            if (ROW_STATE_DEFAULT.equalsIgnoreCase(state)) continue;
            for (DWDataRow row : rows) {
                if ("D".equals(state) && !row.isDeleted()) {
                    row.delete();
                    continue;
                }
                row.set("$state", (Object)state);
            }
        }
    }

    private void buildDataTableDelectionRows(DWDataTable dt) {
        if (this.deletedOids == null) {
            return;
        }
        DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)this.name, DWRdbmsMetadata.class);
        Collection pks = metadata.getPrimaryKeys();
        String primaryKey = null;
        if (pks.size() == 1) {
            primaryKey = (String)pks.iterator().next();
        }
        for (Object oid : this.deletedOids) {
            DWDataRow row = dt.newRow();
            if (oid instanceof Map) {
                row.importOrgData((Map)oid);
            } else if (oid instanceof String || oid instanceof Number) {
                if (primaryKey == null) {
                    throw new DWDataException("13026", "the oid is primitive type, but there are more than one pk!");
                }
                row.set(primaryKey, oid);
            } else {
                throw new DWDataException("13027", "the oid is not map, not support yet!");
            }
            if (row.isDeleted()) continue;
            row.delete();
        }
    }
}

