/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;

public class DWDataTableHandler
implements ResultSetHandler<DWDataTable> {
    private final RowProcessor convert = new BasicRowProcessor();
    private DWQueryInfo queryInfo;

    public DWDataTableHandler(DWQueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    public DWDataTable handle(ResultSet rs) throws SQLException {
        DWDataTable dataTable = null;
        String tableName = null;
        if (this.queryInfo != null) {
            tableName = this.queryInfo.getTableName();
        }
        if (tableName == null || tableName.isEmpty()) {
            int columnCount = rs.getMetaData().getColumnCount();
            HashSet<String> tableNames = new HashSet<String>();
            for (int i = 1; i <= columnCount; ++i) {
                tableNames.add(rs.getMetaData().getTableName(i));
            }
            tableName = (String)tableNames.iterator().next();
        }
        DWDataSet dataset = new DWDataSet();
        dataTable = dataset.newTable(tableName);
        while (rs.next()) {
            this.handleRow(dataTable, rs);
        }
        return dataTable;
    }

    public void handleRow(DWDataTable dataTable, ResultSet rs) throws SQLException {
        Map orgData = this.convert.toMap(rs);
        dataTable.newRow(orgData);
    }
}

