/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataRowState;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.DWReferenceDataRowCollection;
import com.digiwin.app.data.exceptions.DWDataException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWDataRow
implements Serializable {
    private transient DWDataRow parentRow;
    private transient DWDataRowCollection owner;
    private Map<String, Object> data = new HashMap<String, Object>();
    private boolean susspendDirtyReaction = false;

    protected DWDataRow(DWDataRowCollection owner) {
        this(owner, false);
    }

    protected DWDataRow(DWDataRowCollection owner, boolean initDataKeys) {
        this.owner = owner;
        if (initDataKeys) {
            this.initDataKeys();
        }
    }

    private void setDirty() {
        if (this.susspendDirtyReaction) {
            return;
        }
        if (!this.isNew() && !this.isDeleted()) {
            this.set("$state", (Object)"U");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importOrgData(Map<String, Object> orgData) {
        this.data.clear();
        this.susspendDirtyReaction = true;
        try {
            for (Map.Entry<String, Object> cell : orgData.entrySet()) {
                this.set(cell.getKey(), cell.getValue());
            }
            if (this.isDeleted()) {
                this.delete();
            }
        }
        finally {
            this.susspendDirtyReaction = false;
        }
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    protected void setParentRow(DWDataRow parentRow) {
        this.parentRow = parentRow;
    }

    public DWDataRow getParentRow() {
        return this.parentRow;
    }

    public DWDataTable getDataTable() {
        return this.owner == null ? null : this.owner.getOwner();
    }

    public DWDataSet getDWDataSet() {
        DWDataTable dataTable = this.getDataTable();
        if (dataTable != null && dataTable.getOwner() != null) {
            return dataTable.getOwner().getOwner();
        }
        return null;
    }

    public boolean isNew() {
        String state = DWDataRowState.getRowState(this.getSourceData());
        if (state == null) {
            return false;
        }
        return "C".equals(state);
    }

    public boolean isUpdate() {
        String state = DWDataRowState.getRowState(this.getSourceData());
        if (state == null) {
            return false;
        }
        return "U".equals(state);
    }

    public boolean isDeleted() {
        String state = DWDataRowState.getRowState(this.getSourceData());
        if (state == null) {
            return false;
        }
        return "D".equals(state);
    }

    public String getState() {
        return DWDataRowState.getRowState(this);
    }

    public DWDataRow setState(String state) {
        DWDataRowState.setRowState(this, state);
        return this;
    }

    public void delete() {
        this.owner.delete(this);
    }

    public boolean recovery() {
        return this.owner.recovery(this);
    }

    public boolean recovery(String state) {
        return this.owner.recovery(this, state);
    }

    public boolean recovery(int assignedIndex) {
        return this.owner.recovery(this, assignedIndex);
    }

    public boolean recovery(String state, int assignedIndex) {
        return this.owner.recovery(this, state, assignedIndex);
    }

    private void initDataKeys() {
        String[] columnNames;
        DWDataTable table = this.getDataTable();
        if (table == null) {
            return;
        }
        for (String columnName : columnNames = table.getColumns().getColumnNames()) {
            this.data.put(columnName, null);
        }
    }

    public DWDataRow set(String columnName, Object value) {
        boolean isExistsInMetadata = this.checkColumn(columnName);
        ArrayList<Map<String, Object>> childRows = null;
        String childTableName = null;
        if (value instanceof DWDataSet) {
            if (this.getDWDataSet() == value) {
                throw new DWDataException("13023", "Circular reference dataset value is not allow!");
            }
            Map<String, Object> sourceMap = ((DWDataSet)value).getSourceMap();
            if (sourceMap == null || sourceMap.size() == 0) {
                value = null;
            } else if (sourceMap.size() > 1) {
                if (!sourceMap.containsKey(columnName)) {
                    throw new DWDataException("13024", "The value contains more than one data table!");
                }
                value = sourceMap.get(columnName);
            } else {
                Map.Entry<String, Object> firstItem = sourceMap.entrySet().iterator().next();
                value = firstItem.getValue();
            }
        } else if (value instanceof DWDataTable) {
            DWDataTable dataTable = (DWDataTable)value;
            if (this.getDWDataSet() == dataTable.getOwner().getOwner()) {
                throw new DWDataException("13025", "DWDataTable is already exist in the dataset!");
            }
            ArrayList rows = new ArrayList();
            dataTable.getRows().stream().forEach(row -> rows.add(row.getSourceData()));
            value = rows;
        }
        if (value instanceof Map && !"$info".equalsIgnoreCase(columnName)) {
            childRows = new ArrayList<Map<String, Object>>();
            childRows.add((Map)value);
        } else if (value instanceof List) {
            childRows = (ArrayList<Map<String, Object>>)value;
        }
        if (childRows != null) {
            childTableName = columnName;
            DWDataSet dataset = this.getDWDataSet();
            DWDataTable childDataTable = dataset.getTable(childTableName, false);
            if (childDataTable == null) {
                childDataTable = new DWDataTable(childTableName);
                dataset.getTables().add(childDataTable);
            }
            DWReferenceDataRowCollection refDataRowCollection = new DWReferenceDataRowCollection(this.getDataTable(), this, childDataTable, childRows);
            value = refDataRowCollection;
        }
        Object oldValue = this.data.get(columnName);
        this.data.put(columnName, value);
        if (childRows == null && isExistsInMetadata && oldValue != value && !DWDataRowState.isRowStateColumn(columnName)) {
            this.setDirty();
        }
        return this;
    }

    public DWDataRow set(int columnIndex, Object value) {
        String[] columnNames = this.getDataTable().getColumns().getColumnNames();
        String columnName = columnNames[columnIndex];
        this.set(columnName, value);
        return this;
    }

    public DWDataRow setValueInColumnOrders(Object ... values) {
        String[] columnNames = this.getDataTable().getColumns().getColumnNames();
        for (int i = 0; i < values.length; ++i) {
            this.set(columnNames[i], values[i]);
        }
        return this;
    }

    public <T> T get(String columnName) {
        this.checkColumn(columnName);
        Object value = this.data.get(columnName);
        if (value == null) {
            return null;
        }
        return (T)this.data.get(columnName);
    }

    private boolean checkColumn(String columnName) {
        return this.getDataTable().getColumns().hasColumn(columnName);
    }

    public Object[] getValues() {
        String[] columnNames = this.getDataTable().getColumns().getColumnNames();
        Object[] values = new Object[columnNames.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.get(columnNames[i]);
        }
        return values;
    }

    public void persist() {
        this.set("$state", null);
        this.owner.persist(this);
    }

    protected void removeColumn(String columnName) {
        this.data.remove(columnName);
    }

    protected Map<String, Object> getSourceData() {
        return this.data;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()).append("->").append(this.data);
        return result.toString();
    }
}

