/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.data.exceptions.DWDataTableDuplicateException;
import com.digiwin.app.data.exceptions.DWDataTableNotFoundException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class DWDataTableCollection
implements Iterable<DWDataTable>,
Serializable {
    private transient DWDataSet dataSet;
    private DWDataTable primaryTable;
    private ConcurrentHashMap<String, DWDataTable> tables;

    public DWDataTableCollection() {
    }

    protected DWDataTableCollection(DWDataSet owner) {
        this.dataSet = owner;
        this.tables = new ConcurrentHashMap();
    }

    protected void setOwner(DWDataSet dataSet) {
        this.dataSet = dataSet;
    }

    protected DWDataSet getOwner() {
        return this.dataSet;
    }

    public DWDataTable get(String tableName) {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("tableName is null or empty!");
        }
        if (!this.tables.containsKey(tableName)) {
            throw new DWDataTableNotFoundException(tableName);
        }
        return this.tables.get(tableName);
    }

    public DWDataTable getPrimaryTable() {
        return this.primaryTable;
    }

    public String[] getNames() {
        Set keys = this.tables.keySet();
        String[] names = keys.toArray(new String[keys.size()]);
        return names;
    }

    public DWDataTableCollection add(DWDataTable dataTable) {
        if (dataTable == null) {
            throw new IllegalArgumentException("dataTable is null!");
        }
        String name = dataTable.getName();
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("dataTable's name is null or empty!");
        }
        if (this.tables.containsKey(name)) {
            throw new DWDataTableDuplicateException(name);
        }
        dataTable.setOwner(this);
        this.tables.put(name, dataTable);
        if (this.tables.size() == 1) {
            this.primaryTable = dataTable;
        }
        this.getOwner().setDirty();
        return this;
    }

    public DWDataTable remove(String name) {
        if (name == null || name.isEmpty()) {
            throw new DWDataException("dataTable's name is null or empty!");
        }
        DWDataTable table = this.tables.remove(name);
        if (table != null) {
            this.getOwner().setDirty();
        }
        return table;
    }

    protected void onTableRename(DWDataTable target, String newName) {
        if (newName == null || newName.isEmpty()) {
            throw new IllegalArgumentException("newName is null or empty!");
        }
        if (this.tables.containsKey(newName)) {
            throw new DWDataTableDuplicateException(newName);
        }
        this.tables.remove(target.getName());
        this.tables.put(newName, target);
    }

    @Override
    public Iterator<DWDataTable> iterator() {
        return this.tables.values().iterator();
    }

    public Stream<DWDataTable> stream() {
        return this.tables.values().stream();
    }

    public boolean contains(String name) {
        return this.tables.contains(name);
    }

    public int size() {
        return this.tables.size();
    }

    public void clear() {
        this.tables.clear();
    }
}

