/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.dao.filter.DWAbstractManagementFieldResolver;
import com.digiwin.app.service.DWServiceContext;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.Date;
import java.util.Map;

public class DWProfileManagementFieldResolver
extends DWAbstractManagementFieldResolver {
    @Override
    protected Object getFieldValue(String fieldName, String mappingKey) {
        if (mappingKey.startsWith("$")) {
            return this.getTimeTypeValue(mappingKey);
        }
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            return null;
        }
        return profile.get(mappingKey);
    }

    private Object getTimeTypeValue(String mappingKey) {
        String lowerCaseMappingKey;
        Date result = null;
        switch (lowerCaseMappingKey = mappingKey.toLowerCase()) {
            case "$time": {
                result = Time.valueOf(LocalTime.now());
                break;
            }
            case "$date": {
                result = new java.sql.Date(new Date().getTime());
                break;
            }
            case "$datetime": 
            case "$timestamp": {
                result = new Timestamp(new Date().getTime());
                break;
            }
        }
        return result;
    }
}

