/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.DWDataException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class DWSQLManagementFieldFilter
implements IDWSQLFilter {
    private static boolean mgmtFieldEnabled;
    public static String OPTION_MANAGEMENT_FIELD_ENABLED;
    public static String PROPERTY_KEY_MGMT_FIELD_RESOLVER;
    public static String TAG_MGMT_FIELD_INSERT_COLUMNS;
    public static String TAG_MGMT_FIELD_INSERT_PARAMS;
    public static String TAG_MGMT_FIELD_UPDATE_COLUMNS;
    public static String TAG_DISABLE_MGMT_FIELDS;
    private IDWManagementFieldResolver mgmtFieldResolver;

    public DWSQLManagementFieldFilter(IDWManagementFieldResolver mgmtFieldResolver) {
        if (mgmtFieldResolver == null) {
            throw new IllegalArgumentException("mgmtFieldResolver is null!");
        }
        this.mgmtFieldResolver = mgmtFieldResolver;
    }

    public static boolean isEnabled() {
        return mgmtFieldEnabled;
    }

    public static void disableInOptions(IDWSQLOptions options) {
        DWSQLManagementFieldFilter.setEnabledInOptions(options, false);
    }

    public static void setEnabledInOptions(IDWSQLOptions options, boolean enabled) {
        options.set(OPTION_MANAGEMENT_FIELD_ENABLED, enabled);
    }

    public static boolean isEnabled(IDWSQLOptions options) {
        if (options == null) {
            return mgmtFieldEnabled;
        }
        boolean enabled = options.get(OPTION_MANAGEMENT_FIELD_ENABLED, mgmtFieldEnabled);
        return enabled;
    }

    @Override
    public void doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        if (!DWSQLManagementFieldFilter.isEnabled(options)) {
            return;
        }
        String sql = sqlInfo.getSql();
        List<Object> parameters = sqlInfo.getParametersAsList();
        if (sql.contains(TAG_DISABLE_MGMT_FIELDS)) {
            sql = sql.replaceAll(Pattern.quote(TAG_DISABLE_MGMT_FIELDS), "");
        } else {
            CharSequence[] insertFields = this.mgmtFieldResolver.getInsertFields();
            String[] updateFields = this.mgmtFieldResolver.getUpdateFields();
            boolean insertFieldCountZero = insertFields.length == 0;
            boolean hasTag = false;
            if (sql.contains(TAG_MGMT_FIELD_INSERT_COLUMNS)) {
                hasTag = true;
                String replacedColumnString = (insertFieldCountZero ? "" : ", ") + String.join((CharSequence)", ", insertFields);
                sql = sql.replaceAll(Pattern.quote(TAG_MGMT_FIELD_INSERT_COLUMNS), replacedColumnString);
            }
            if (sql.contains(TAG_MGMT_FIELD_INSERT_PARAMS)) {
                hasTag = true;
                String replacedParameterString = (insertFieldCountZero ? "" : ", ") + String.join((CharSequence)", ", Collections.nCopies(insertFields.length, "?"));
                sql = sql.replaceAll(Pattern.quote(TAG_MGMT_FIELD_INSERT_PARAMS), replacedParameterString);
                parameters.addAll(this.mgmtFieldResolver.getInsertFieldValues());
            }
            if (sql.contains(TAG_MGMT_FIELD_UPDATE_COLUMNS)) {
                hasTag = true;
                ArrayList<String> columnValueSetList = new ArrayList<String>();
                for (String updateField : updateFields) {
                    Object value = this.mgmtFieldResolver.getFieldValue(updateField);
                    String columnValueSet = updateField + "=";
                    columnValueSet = columnValueSet + (value == null ? "null" : "'" + value.toString() + "'");
                    columnValueSetList.add(columnValueSet);
                }
                String replacedParameterString = (columnValueSetList.size() == 0 ? "" : ", ") + String.join((CharSequence)", ", columnValueSetList);
                sql = sql.replaceAll(Pattern.quote(TAG_MGMT_FIELD_UPDATE_COLUMNS), replacedParameterString);
            }
            if (!hasTag) {
                throw new DWDataException("13014", String.format("[DWSQLManagementFieldFilter] related management field tag(%s/%s/%s) is missing in sql.", TAG_MGMT_FIELD_INSERT_COLUMNS, TAG_MGMT_FIELD_INSERT_PARAMS, TAG_MGMT_FIELD_UPDATE_COLUMNS));
            }
        }
        sqlInfo.setSqlAndParameters(sql, parameters);
    }

    @Override
    public void doFilter(DWQueryInfo queryInfo, IDWSQLOptions options) {
    }

    @Override
    public void doFilter(DWDataRow dataRow, IDWSQLOptions options) {
        block4: {
            String[] updateFields;
            block3: {
                String[] insertFields;
                if (!DWSQLManagementFieldFilter.isEnabled(options)) {
                    return;
                }
                if (!dataRow.isNew()) break block3;
                for (String fieldName : insertFields = this.mgmtFieldResolver.getInsertFields()) {
                    dataRow.set(fieldName, this.mgmtFieldResolver.getFieldValue(fieldName));
                }
                break block4;
            }
            if (!dataRow.isUpdate()) break block4;
            for (String fieldName : updateFields = this.mgmtFieldResolver.getUpdateFields()) {
                dataRow.set(fieldName, this.mgmtFieldResolver.getFieldValue(fieldName));
            }
        }
    }

    static {
        OPTION_MANAGEMENT_FIELD_ENABLED = "mgmtFieldEnabled";
        PROPERTY_KEY_MGMT_FIELD_RESOLVER = "mgmtFieldResolver";
        TAG_MGMT_FIELD_INSERT_COLUMNS = "${mgmtFieldInsertColumns}";
        TAG_MGMT_FIELD_INSERT_PARAMS = "${mgmtFieldInsertParams}";
        TAG_MGMT_FIELD_UPDATE_COLUMNS = "${mgmtFieldUpdateColumns}";
        TAG_DISABLE_MGMT_FIELDS = "-${mgmtField}";
        String mgmtFieldEnabledString = DWApplicationConfigUtils.getProperty((String)OPTION_MANAGEMENT_FIELD_ENABLED, (String)"false");
        mgmtFieldEnabled = "true".equalsIgnoreCase(mgmtFieldEnabledString);
    }
}

