/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTableBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class DWDataSetBuilder {
    private List<DWDataTableBuilder> tableBuilders = new ArrayList<DWDataTableBuilder>();

    public DWDataSet create() {
        DWDataSet dataset = new DWDataSet();
        for (DWDataTableBuilder tbb : this.tableBuilders) {
            tbb.create(dataset);
        }
        return dataset;
    }

    public DWDataTableBuilder addTable(String tableName) {
        DWDataTableBuilder tableBuilder = new DWDataTableBuilder(this);
        tableBuilder.setName(tableName);
        this.tableBuilders.add(tableBuilder);
        return tableBuilder;
    }

    public DWDataTableBuilder getTable(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is null or empty!");
        }
        Optional<DWDataTableBuilder> matchedItem = this.tableBuilders.stream().filter(t -> name.equals(t.getName())).findFirst();
        return matchedItem.get();
    }
}

