/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data.exceptions;

import com.digiwin.app.dao.DWDataSetSqlInfo;
import com.digiwin.app.data.DWDataOptimisticLockingInfo;
import com.digiwin.app.data.exceptions.DWDataException;

public class DWDataOptimisticLockingException
extends DWDataException {
    private static final long serialVersionUID = 1L;

    public String getErrorCode() {
        return "13006";
    }

    @Override
    public void rethrow(String errorCode, Throwable cause, String tableName, String operation, DWDataSetSqlInfo datasqlInfo, int index) {
        String errorMessage = DWDataOptimisticLockingException.errorMessageFormatter(cause, tableName, operation, datasqlInfo, index);
        DWDataOptimisticLockingException lock = new DWDataOptimisticLockingException(errorCode, errorMessage);
        lock.setStackTrace(this.getStackTrace());
        throw lock;
    }

    public DWDataOptimisticLockingException() {
    }

    public DWDataOptimisticLockingException(String errorCode, String errorMessage) {
        super(errorCode, errorMessage);
    }

    public DWDataOptimisticLockingException(DWDataOptimisticLockingInfo lockingInfo) {
        super(DWDataOptimisticLockingException.createMessage(lockingInfo));
    }

    private static String createMessage(DWDataOptimisticLockingInfo lockingInfo) {
        String errorMessage = String.format("%s - Locking Failure!", lockingInfo.toString());
        return errorMessage;
    }
}

