/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWQueryElement;
import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryJoinOperator;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSQLBuilder;
import com.digiwin.app.dao.DWSqlInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DWQueryCondition
implements DWSQLBuilder,
DWQueryElement,
Cloneable {
    DWQueryJoinOperator joinOperator;
    private DWQueryCondition parent;
    private List<DWQueryElement> items = new ArrayList<DWQueryElement>();
    private String tableName;

    public DWQueryCondition() {
    }

    public DWQueryCondition(DWQueryJoinOperator operator) {
        this.joinOperator = operator;
    }

    public DWQueryJoinOperator getJoinOperator() {
        if (this.joinOperator == null) {
            return DWQueryJoinOperator.AND;
        }
        return this.joinOperator;
    }

    public DWQueryCondition getParentCondition() {
        return this.parent;
    }

    @Deprecated
    public DWQueryCondition AND() {
        this.joinOperator = DWQueryJoinOperator.AND;
        return this;
    }

    @Deprecated
    public DWQueryCondition OR() {
        this.joinOperator = DWQueryJoinOperator.OR;
        return this;
    }

    public DWQueryCondition ANDJoin() {
        this.joinOperator = DWQueryJoinOperator.AND;
        return this;
    }

    public DWQueryCondition ORJoin() {
        this.joinOperator = DWQueryJoinOperator.OR;
        return this;
    }

    public DWQueryCondition addCondition(DWQueryCondition nestedCondition) {
        if (nestedCondition != null) {
            if (nestedCondition.parent != null) {
                throw new IllegalArgumentException("nestedCondition's parent is not null!");
            }
            DWQueryCondition checkingParentCondition = this;
            while (checkingParentCondition != null) {
                if (checkingParentCondition.parent == nestedCondition) {
                    throw new IllegalArgumentException("this nestedCondition is already in the hierarchy!");
                }
                checkingParentCondition = checkingParentCondition.parent;
            }
            nestedCondition.parent = this;
            this.items.add(nestedCondition);
        }
        return this;
    }

    public DWQueryCondition addFieldInfo(String name, DWQueryValueOperator operator, Object ... values) {
        DWQueryField fieldInfo = new DWQueryField(name, operator, values);
        this.items.add(fieldInfo);
        return this;
    }

    public DWQueryCondition addEqualInfo(String name, Object value) {
        DWQueryField fieldInfo = new DWQueryField(name, DWQueryValueOperator.EQUAL, value);
        this.items.add(fieldInfo);
        return this;
    }

    public DWQueryCondition addBetweenInfo(String name, Object value1, Object value2) {
        DWQueryField fieldInfo = new DWQueryField(name, DWQueryValueOperator.BETWEEN, value1, value2);
        this.items.add(fieldInfo);
        return this;
    }

    public List<DWQueryElement> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public DWQueryElement getItem(int index) {
        return this.items.get(index);
    }

    public int size() {
        return this.items.size();
    }

    public DWQueryCondition clone() {
        try {
            return (DWQueryCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DWSqlInfo build() {
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

