/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryJoin;
import com.digiwin.app.dao.DWQueryJoinOn;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryOrderby;
import com.digiwin.app.dao.DWQueryValueOperator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DWQueryInfo
implements Serializable {
    private String tableName;
    private DWQueryCondition condition = new DWQueryCondition();
    private DWQueryCondition fixedCondition = new DWQueryCondition();
    private List<DWQueryOrderby> orderfields = new ArrayList<DWQueryOrderby>();
    private Map<String, DWQueryJoin> joins = new ConcurrentHashMap<String, DWQueryJoin>();
    private boolean distinct = false;
    private List<String> selectFields;
    private boolean selectAll = false;

    public DWQueryInfo setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public DWQueryInfo() {
    }

    public DWQueryInfo(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.condition.setTableName(this.tableName);
        this.tableName = tableName;
    }

    public DWQueryCondition getCondition() {
        return this.condition;
    }

    public DWQueryInfo setCondition(DWQueryCondition condition) {
        if (condition == null) {
            condition = new DWQueryCondition();
        }
        condition.setTableName(this.tableName);
        this.condition = condition;
        return this;
    }

    public DWQueryCondition getFixedCondition() {
        return this.fixedCondition;
    }

    public DWQueryInfo setFixedCondition(DWQueryCondition condition) {
        if (condition == null) {
            condition = new DWQueryCondition();
        }
        this.fixedCondition = condition;
        return this;
    }

    public DWQueryInfo toOR() {
        this.condition.OR();
        return this;
    }

    public List<DWQueryOrderby> getOrderfields() {
        return this.orderfields;
    }

    public DWQueryInfo addFieldInfo(String name, DWQueryValueOperator operator, Object ... values) {
        this.condition.addFieldInfo(name, operator, values);
        return this;
    }

    public DWQueryInfo addEqualInfo(String name, Object value) {
        this.condition.addEqualInfo(name, value);
        return this;
    }

    public DWQueryInfo addBetweenInfo(String name, Object value1, Object value2) {
        this.condition.addBetweenInfo(name, value1, value2);
        return this;
    }

    public List<String> getSelectFields() {
        return this.selectFields;
    }

    @Deprecated
    public void setSelectFields(List<String> selectFields) {
        this.selectFields = selectFields;
    }

    public DWQueryInfo setSelectFields(String ... fields) {
        this.selectFields = Arrays.asList(fields);
        return this;
    }

    public DWQueryInfo removeSelectFields(String field) {
        this.selectFields.remove(field);
        return this;
    }

    public void setOrderfields(List<DWQueryOrderby> orderfields) {
        this.orderfields = orderfields;
    }

    public DWQueryInfo addOrderBy(String name) {
        return this.addOrderBy(name, true);
    }

    public DWQueryInfo addOrderBy(String name, boolean ascending) {
        DWQueryOrderby field = new DWQueryOrderby(name);
        if (ascending) {
            field.setOrderby(DWQueryOrderby.SORT_ASCENDING);
        } else {
            field.setOrderby(DWQueryOrderby.SORT_DESCENDING);
        }
        this.orderfields.add(field);
        return this;
    }

    public List<DWQueryOrderby> addSuffixOrderby(String name, String orderby) {
        this.orderfields.add(new DWQueryOrderby(name, orderby));
        return this.orderfields;
    }

    public List<DWQueryOrderby> addPrefixOrderby(String name, String orderby) {
        this.orderfields.add(0, new DWQueryOrderby(name, orderby));
        return this.orderfields;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public DWQueryInfo setJoinInfo(DWQueryJoinRelation relation, String joinTableName, String tableAlias, String fromField, DWQueryValueOperator operator, String joinField) {
        DWQueryJoinOn on = new DWQueryJoinOn();
        on.setFromField(fromField);
        if (operator != null) {
            on.setOperator(operator);
        }
        on.setJoinField(joinField);
        ArrayList<DWQueryJoinOn> onArray = new ArrayList<DWQueryJoinOn>();
        onArray.add(on);
        return this.setJoinInfo(relation, joinTableName, tableAlias, onArray);
    }

    public DWQueryInfo setJoinInfo(DWQueryJoinRelation relation, String joinTableName, String fromField, DWQueryValueOperator operator, String joinField) {
        DWQueryJoinOn on = new DWQueryJoinOn();
        on.setFromField(fromField);
        on.setOperator(operator);
        on.setJoinField(joinField);
        ArrayList<DWQueryJoinOn> onArray = new ArrayList<DWQueryJoinOn>();
        onArray.add(on);
        return this.setJoinInfo(relation, joinTableName, "Alias" + this.tableName, onArray);
    }

    public DWQueryInfo setJoinInfo(DWQueryJoinRelation relation, String joinTableName, String tableAlias, String fromField, String joinField) {
        return this.setJoinInfo(relation, joinTableName, tableAlias, fromField, null, joinField);
    }

    public DWQueryInfo setJoinInfo(DWQueryJoinRelation relation, String joinTableName, String fromField, String joinField) {
        return this.setJoinInfo(relation, joinTableName, "Alias" + this.tableName, fromField, null, joinField);
    }

    public DWQueryInfo setJoinInfo(DWQueryJoinRelation relation, String joinTableName, String tableAlias, List<DWQueryJoinOn> on) {
        DWQueryJoin join = new DWQueryJoin();
        join.setRelation(relation);
        join.setTableName(joinTableName);
        join.setTableAlias(tableAlias);
        join.setOn(on);
        this.joins.put(joinTableName, join);
        return this;
    }

    public DWQueryInfo setJoinInfo(DWQueryJoinRelation relation, String joinTableName, List<DWQueryJoinOn> ons) {
        return this.setJoinInfo(relation, joinTableName, "Alias" + this.tableName, ons);
    }

    public DWQueryInfo addJoinTableSelectField(String joinTableName, String ... selectFields) {
        DWQueryJoin join = new DWQueryJoin();
        if (this.joins.containsKey(joinTableName)) {
            join = this.joins.get(joinTableName);
        }
        for (String selectField : selectFields) {
            join.addSelectField(selectField);
        }
        this.joins.put(joinTableName, join);
        return this;
    }

    public List<DWQueryJoin> getJoin() {
        ArrayList<DWQueryJoin> joinArray = new ArrayList<DWQueryJoin>();
        for (Map.Entry<String, DWQueryJoin> entry : this.joins.entrySet()) {
            String joinTableName = entry.getKey();
            DWQueryJoin join = entry.getValue();
            join.setTableName(joinTableName);
            joinArray.add(join);
        }
        return joinArray;
    }

    public DWQueryInfo setJoin(String joinTableName, DWQueryJoin join) {
        this.joins.put(joinTableName, join);
        return this;
    }

    public DWQueryInfo moveSelectFieldToJoinTableSelectField(String joinTableName, String field) {
        this.addJoinTableSelectField(joinTableName, field);
        this.removeSelectFields(field);
        return this;
    }
}

