/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data.validation;

import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.data.validation.DWVDQueryInfo;
import com.digiwin.app.data.validation.DWVDQueryInfos;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.app.validation.DWConstraintViolationException;
import java.util.Arrays;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class DWQueryInfosValidator
implements ConstraintValidator<DWVDQueryInfos, DWQueryInfo> {
    private DWVDQueryInfo[] vdQueryInfos;

    public void initialize(DWVDQueryInfos constraintAnnotation) {
        DWVDQueryInfo[] vdQueryInfos;
        for (DWVDQueryInfo vdQueryInfo : vdQueryInfos = constraintAnnotation.value()) {
            DWQueryInfosValidator.validateParameters(vdQueryInfo);
        }
        this.vdQueryInfos = vdQueryInfos;
    }

    public boolean isValid(DWQueryInfo value, ConstraintValidatorContext context) {
        return DWQueryInfosValidator.isValid(this.vdQueryInfos, value, context);
    }

    static void validateParameters(DWVDQueryInfo queryInfo) {
    }

    static boolean isValid(DWVDQueryInfo[] vdQueryInfos, DWQueryInfo value, ConstraintValidatorContext context) {
        DWPagableQueryInfo pagableInfo;
        String inputTableName = value.getTableName();
        if (inputTableName == null) {
            return true;
        }
        DWVDQueryInfo mappingVDQueryInfo = Arrays.stream(vdQueryInfos).filter(vdQueryInfo -> inputTableName.equalsIgnoreCase(vdQueryInfo.name())).findFirst().orElse(null);
        if (mappingVDQueryInfo == null) {
            String errorCode = DWConstraintViolationException.ERROR_CODE + "_3";
            String errorMessage = DWApplicationMessageResourceBundleUtils.getString((String)errorCode, (Object[])new Object[]{inputTableName});
            context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            context.disableDefaultConstraintViolation();
            return false;
        }
        if (mappingVDQueryInfo.maxPageSize() > -1 && value instanceof DWPagableQueryInfo && (pagableInfo = (DWPagableQueryInfo)value).getPageSize() > mappingVDQueryInfo.maxPageSize()) {
            String errorCode = DWConstraintViolationException.ERROR_CODE + "_4";
            String errorMessage = DWApplicationMessageResourceBundleUtils.getString((String)errorCode, (Object[])new Object[]{mappingVDQueryInfo.maxPageSize()});
            context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            context.disableDefaultConstraintViolation();
            return false;
        }
        return true;
    }
}

