/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.config;

import com.ctrip.replica.apollo.core.utils.StringUtils;
import com.digiwin.app.common.DWAdapterConfigUtils;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.dao.DWDaoImpl;
import com.digiwin.app.dao.MultiTenancyInterceptor;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class DWDaoConfig {
    @Bean(name={"dw-dataSource"})
    public BasicDataSource basicDataSource(DWAdapterConfigUtils adapterConfigUtils) {
        String driverClassName = DWApplicationConfigUtils.getProperty((String)"jdbcDriverClassName");
        String dbUrl = DWApplicationConfigUtils.getProperty((String)"dbUrl");
        String dbUsername = DWApplicationConfigUtils.getProperty((String)"dbUsername");
        String dbPassword = DWApplicationConfigUtils.getProperty((String)"dbPassword");
        String dbConnectionInitialSize = DWApplicationConfigUtils.getProperty((String)"dbConnectionInitialSize");
        String dbConnectionMinIdle = DWApplicationConfigUtils.getProperty((String)"dbConnectionMinIdle");
        String dbConnectionMaxIdle = DWApplicationConfigUtils.getProperty((String)"dbConnectionMaxIdle");
        String dbConnectionMaxTotal = DWApplicationConfigUtils.getProperty((String)"dbConnectionMaxTotal");
        String dbConnectionMaxWaitMillis = DWApplicationConfigUtils.getProperty((String)"dbConnectionMaxWaitMillis");
        BasicDataSource basicDataSource = new BasicDataSource();
        if (StringUtils.isBlank((String)dbUrl)) {
            return basicDataSource;
        }
        String dbEnabled = DWApplicationConfigUtils.getProperty((String)"dbEnabled");
        if ("false".equals(dbEnabled)) {
            return basicDataSource;
        }
        basicDataSource.setDriverClassName(driverClassName);
        basicDataSource.setUrl(dbUrl);
        basicDataSource.setUsername(dbUsername);
        basicDataSource.setPassword(dbPassword);
        basicDataSource.setInitialSize(Integer.valueOf(dbConnectionInitialSize).intValue());
        basicDataSource.setMinIdle(Integer.valueOf(dbConnectionMinIdle).intValue());
        if (dbConnectionMaxIdle != null) {
            basicDataSource.setMaxIdle(Integer.valueOf(dbConnectionMaxIdle).intValue());
        } else {
            basicDataSource.setMaxIdle(Integer.valueOf(dbConnectionMaxTotal).intValue());
        }
        basicDataSource.setMaxTotal(Integer.valueOf(dbConnectionMaxTotal).intValue());
        basicDataSource.setMaxWaitMillis((long)Integer.valueOf(dbConnectionMaxWaitMillis).intValue());
        return basicDataSource;
    }

    @Bean(name={"dw-proxyDataSource"})
    public TransactionAwareDataSourceProxy transactionAwareDataSourceProxy(@Qualifier(value="dw-dataSource") BasicDataSource basicDataSource) {
        TransactionAwareDataSourceProxy transactionAwareDataSourceProxy = new TransactionAwareDataSourceProxy((DataSource)basicDataSource);
        return transactionAwareDataSourceProxy;
    }

    @Bean(name={"dw-queryRunner"})
    public QueryRunner queryRunner(@Qualifier(value="dw-proxyDataSource") TransactionAwareDataSourceProxy transactionAwareDataSourceProxy) {
        QueryRunner queryRunner = new QueryRunner((DataSource)transactionAwareDataSourceProxy);
        return queryRunner;
    }

    @Bean(name={"dw-dao"})
    public DWDaoImpl dwDaoImpl(@Qualifier(value="dw-queryRunner") QueryRunner queryRunner) {
        DWDaoImpl dao = new DWDaoImpl(queryRunner);
        return dao;
    }

    @Bean(name={"daoMultiTenancyInterceptor"})
    public MultiTenancyInterceptor multiTenancyInterceptor() {
        MultiTenancyInterceptor multiTenancyInterceptor = new MultiTenancyInterceptor();
        return multiTenancyInterceptor;
    }

    @Bean(name={"daoMultiTenancyAdvisor"})
    public Advisor daoMultiTenancyAdvisor(@Qualifier(value="daoMultiTenancyInterceptor") MultiTenancyInterceptor multiTenancyInterceptor) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(* com.digiwin.app.dao.DWDaoImpl.*(..)) and args(String,..)");
        DefaultBeanFactoryPointcutAdvisor advisor = new DefaultBeanFactoryPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)multiTenancyInterceptor);
        return advisor;
    }

    @Bean(name={"dw-transactionManager"})
    public DataSourceTransactionManager dataSourceTransactionManager(@Qualifier(value="dw-proxyDataSource") TransactionAwareDataSourceProxy transactionAwareDataSourceProxy) {
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource((DataSource)transactionAwareDataSourceProxy);
        return dataSourceTransactionManager;
    }
}

