/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;

public class DWRowProcessor
extends BasicRowProcessor {
    private List<String> selectFields;

    public DWRowProcessor() {
    }

    public DWRowProcessor(BeanProcessor convert) {
        super(convert);
    }

    public void setSelectFields(List<String> selectFields) {
        this.selectFields = selectFields;
    }

    public Map<String, Object> toMap(ResultSet rs) throws SQLException {
        Map result = super.toMap(rs);
        if (this.selectFields != null && !this.selectFields.isEmpty()) {
            CaseInsensitiveHashMap resultBySelectFields = new CaseInsensitiveHashMap();
            for (String selectField : this.selectFields) {
                String selectFieldAfterAs = this.fetchFieldsAfterAs(selectField);
                resultBySelectFields.put(selectFieldAfterAs, result.get(selectFieldAfterAs));
            }
            result = resultBySelectFields;
        }
        return result;
    }

    private String fetchFieldsAfterAs(String expression) {
        String[] keywords;
        String result = expression;
        for (String keyword : keywords = new String[]{" AS ", " As ", " aS ", " as "}) {
            if (!expression.contains(keyword)) continue;
            result = expression.split(keyword)[1].trim();
        }
        return result;
    }

    private static class CaseInsensitiveHashMap
    extends LinkedHashMap<String, Object> {
        private final Map<String, String> lowerCaseMap = new HashMap<String, String>();
        private static final long serialVersionUID = -2848100435296897392L;

        private CaseInsensitiveHashMap() {
        }

        @Override
        public boolean containsKey(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
            return super.containsKey(realKey);
        }

        @Override
        public Object get(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
            return super.get(realKey);
        }

        @Override
        public Object put(String key, Object value) {
            String oldKey = this.lowerCaseMap.put(key.toLowerCase(Locale.ENGLISH), key);
            Object oldValue = super.remove(oldKey);
            super.put(key, value);
            return oldValue;
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.put(key, value);
            }
        }

        @Override
        public Object remove(Object key) {
            String realKey = this.lowerCaseMap.remove(key.toString().toLowerCase(Locale.ENGLISH));
            return super.remove(realKey);
        }
    }
}

