/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql;

import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.exceptions.DWMetadataException;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomizeFieldUtil {
    private static Log log = LogFactory.getLog(CustomizeFieldUtil.class);
    private static String CLASSTAG = "[CustomizeFieldUtil] ";
    private static final String _key_tenantsid = DWTenantUtils.getTenantColumnName();
    private static String custFieldSql = "SELECT * FROM dw_customize_field WHERE table_name = ? AND " + _key_tenantsid + " = ?";

    public static Object getMetadataCacheByTenant() {
        Map result = new HashMap();
        Long tenantsid = CustomizeFieldUtil.getTenantSidValue();
        if (tenantsid != null) {
            result = DWMetadataContainer.getCustMetadatas((Long)tenantsid);
        }
        return result;
    }

    public static Object getMetadataByTenantAndTablename(String targetTableName) {
        HashMap result = new HashMap();
        Long tenantsid = CustomizeFieldUtil.getTenantSidValue();
        if (tenantsid != null) {
            Map tenantData = DWMetadataContainer.getCustMetadatas((Long)tenantsid);
            if (tenantData != null && tenantData.containsKey(targetTableName)) {
                result.put(targetTableName, tenantData.get(targetTableName));
            } else {
                HashMap<String, List<Map<String, Object>>> custTableFields = new HashMap<String, List<Map<String, Object>>>();
                List<Map<String, Object>> custFields = CustomizeFieldUtil.select(custFieldSql, targetTableName, tenantsid);
                custTableFields.put(targetTableName, custFields);
                DWMetadataContainer.addCustMetadatas((Long)tenantsid, custTableFields);
                result = custTableFields;
            }
        }
        return result;
    }

    private static List<Map<String, Object>> select(String statement, Object ... params) throws DWMetadataException {
        ArrayList<HashMap<String, StringBuffer>> result = null;
        QueryRunner queryRunner = (QueryRunner)SpringContextUtils.getBean((String)"dw-queryRunner");
        try {
            result = (ArrayList<HashMap<String, StringBuffer>>)queryRunner.query(statement, (ResultSetHandler)new MapListHandler(), params);
        }
        catch (Exception e) {
            String excpMessage = e.getMessage();
            StringBuffer message = new StringBuffer(CLASSTAG + "select customize field failed! ");
            if (StringUtils.isNotBlank((CharSequence)excpMessage)) {
                message.append(CustomizeFieldUtil.getLimit(excpMessage, 60));
            }
            log.error((Object)message, (Throwable)e);
            HashMap<String, StringBuffer> error = new HashMap<String, StringBuffer>();
            error.put("dw-message-error", message);
            result = new ArrayList<HashMap<String, StringBuffer>>();
            result.add(error);
        }
        return result;
    }

    public static String convertToSelectConditionColumn(String fieldName) {
        if (fieldName.startsWith("cust_field$.")) {
            String[] custFieldAndKey = fieldName.split("\\$.");
            if (custFieldAndKey.length >= 2) {
                String searchCustFieldKey = "$." + custFieldAndKey[1];
                fieldName = " JSON_VALUE( cust_field , '" + searchCustFieldKey + "') ";
                log.debug((Object)(CLASSTAG + " convertToSelectConditionColumn result = '" + fieldName + "'"));
            } else {
                log.error((Object)(CLASSTAG + " convertToSelectConditionColumn(" + fieldName + ") format error"));
            }
        }
        return fieldName;
    }

    public static String convertToSelectInConditionColumn(String fieldName, Object fieldValue) {
        StringBuffer inSql = new StringBuffer();
        if (fieldName.startsWith("cust_field$.")) {
            String[] custFieldAndKey = fieldName.split("\\$.");
            if (custFieldAndKey.length >= 2) {
                String searchCustFieldKey = "$." + custFieldAndKey[1];
                String searchSyntax = " JSON_SEARCH( cust_field , 'one', ?, null, '" + searchCustFieldKey + "')  IS NOT NULL ";
                inSql.append(" (");
                inSql.append(String.join((CharSequence)" OR ", Collections.nCopies(((Object[])fieldValue).length, searchSyntax)));
                inSql.append(") ");
                log.debug((Object)(CLASSTAG + " convertToSelectInConditionColumn(" + fieldName + ") result = '" + inSql + "'"));
            } else {
                log.debug((Object)(CLASSTAG + " convertToSelectInConditionColumn(" + fieldName + ") format error"));
                inSql.append(fieldName);
                inSql.append(" IN (");
                inSql.append(String.join((CharSequence)", ", Collections.nCopies(((Object[])fieldValue).length, "?")));
                inSql.append(")");
            }
        }
        return inSql.toString();
    }

    public static Map<String, Object> getCustFieldsFromMetadata(String tableName) {
        Map custColumns = null;
        DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)tableName, DWRdbmsMetadata.class);
        List fieldNames = metadata.getFields().stream().map(f -> f.getName()).collect(Collectors.toList());
        if (fieldNames.contains("cust_field")) {
            custColumns = (Map)CustomizeFieldUtil.getMetadataByTenantAndTablename(tableName);
        }
        return custColumns;
    }

    private static Long getTenantSidValue() {
        Long tenantsid = null;
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile.containsKey(DWTenantUtils.getIAMTenantSidKey())) {
            tenantsid = (Long)profile.get(DWTenantUtils.getIAMTenantSidKey());
        }
        return tenantsid;
    }

    private static String getLimit(String value, int length) {
        StringBuffer data = new StringBuffer(value);
        if (data.length() > length) {
            data.setLength(length);
            data.append("...");
        }
        return data.toString();
    }
}

