/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.sql.BaseDaoException;
import com.digiwin.app.sql.SQLParser;

public class ColumnValueTypeNotMatchException
extends BaseDaoException {
    public static final int ERROR_CODE = 1366;
    public static final String COLUMN_VALUE_PREFIX = "value: '";
    public static final String COLUMN_VALUE_POSTFIX = "' for";
    public static final int COLUMN_VALUE_PREFIX_INDEX = "value: '".length();
    public static final String COLUMN_NAME_PREFIX = "column '";
    public static final String COLUMN_NAME_POSTFIX = "' at";
    public static final int COLUMN_NAME_PREFIX_INDEX = "column '".length();

    @Override
    public int getErrorCode() throws Exception {
        return 1366;
    }

    @Override
    public void settingFormat(String message, DWDao dao) throws Exception {
        this.exceptionMessageFormat = "[\u8d44\u6599\u5904\u7406\u5f02\u5e38][\u5b57\u6bb5\u8d44\u6599\u578b\u6001\u4e0d\u7b26]\u8d44\u6599\u8868=%s(%s)\uff0c\u5b57\u6bb5=%s(%s)\uff0c\u680f\u4f4d\u578b\u614b=%s\uff0c\u503c=%s";
    }

    @Override
    public void settingArgument(String message, DWDao dao) throws Exception {
        String tableName = SQLParser.fetchTableName(message);
        String columnValue = this.fetchColumnValueMessage(message);
        String columnName = this.fetchColumnNameMessage(message);
        DWRdbmsMetadata metadata = this.getMetadata(tableName);
        DWRdbmsField field = (DWRdbmsField)metadata.getField(columnName);
        this.exceptionMessageArgument.add(metadata.getName());
        this.exceptionMessageArgument.add(metadata.getName());
        this.exceptionMessageArgument.add(field.getName());
        this.exceptionMessageArgument.add(field.getName());
        this.exceptionMessageArgument.add(field.getValueType());
        this.exceptionMessageArgument.add(columnValue);
    }

    private String fetchColumnValueMessage(String message) throws Exception {
        String result = "";
        int leftIndex = message.indexOf(COLUMN_VALUE_PREFIX) + COLUMN_VALUE_PREFIX_INDEX;
        int rightIndex = message.indexOf(COLUMN_VALUE_POSTFIX);
        result = message.substring(leftIndex, rightIndex);
        return result;
    }

    private String fetchColumnNameMessage(String message) throws Exception {
        String result = "";
        int leftIndex = message.indexOf(COLUMN_NAME_PREFIX) + COLUMN_NAME_PREFIX_INDEX;
        int rightIndex = message.indexOf(COLUMN_NAME_POSTFIX);
        result = message.substring(leftIndex, rightIndex);
        return result;
    }
}

