/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.config;

import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.dao.filter.DWProfileManagementFieldResolver;
import com.digiwin.app.dao.filter.DWSQLFilterChain;
import com.digiwin.app.dao.filter.DWSQLManagementFieldFilter;
import com.digiwin.app.dao.filter.DWSQLTenantIsolationFilter;
import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DWSQLFilterChainSpringConfig {
    public static String PROPERTY_KEY_DATA_PERMISSION_SQL_FILTER = "dataPermSqlFilter";

    public static DWSQLFilterChain getFilterChain() throws RuntimeException {
        return (DWSQLFilterChain)SpringContextUtils.getBean((String)"dw-sqlFilterChain");
    }

    @Bean(value={"dw-sqlFilterChain"})
    public DWSQLFilterChain getSQLFilterChain() throws Exception {
        List<IDWSQLFilter> filters = this.getCustomFilters();
        if (filters == null) {
            IDWSQLFilter filter;
            filters = new ArrayList<IDWSQLFilter>();
            if (DWSQLManagementFieldFilter.isEnabled()) {
                filter = DWSQLFilterChainSpringConfig.getDefaultMgmtFieldSQLFilter();
                filters.add(filter);
            }
            filter = new DWSQLTenantIsolationFilter();
            filters.add(filter);
            IDWSQLFilter dataPermSqlFilter = DWSQLFilterChainSpringConfig.getDataPermissionSQLFilter();
            if (dataPermSqlFilter != null) {
                filters.add(dataPermSqlFilter);
            }
        }
        DWSQLFilterChain chain = new DWSQLFilterChain(filters);
        return chain;
    }

    private static IDWManagementFieldResolver getResolver() throws Exception {
        String mgmtFieldResolverClazz = DWApplicationConfigUtils.getProperty((String)DWSQLManagementFieldFilter.PROPERTY_KEY_MGMT_FIELD_RESOLVER, (String)DWProfileManagementFieldResolver.class.getName());
        Class resolverClass = DWApplicationClassLoader.getInstance().loadClass(mgmtFieldResolverClazz);
        return (IDWManagementFieldResolver)resolverClass.newInstance();
    }

    private static DWSQLManagementFieldFilter getDefaultMgmtFieldSQLFilter() throws Exception {
        IDWManagementFieldResolver resolver = DWSQLFilterChainSpringConfig.getResolver();
        DWSQLManagementFieldFilter filter = new DWSQLManagementFieldFilter(resolver);
        return filter;
    }

    private static IDWSQLFilter getDataPermissionSQLFilter() throws Exception {
        IDWSQLFilter result = null;
        String dataPermSqlFilterClassName = DWApplicationConfigUtils.getProperty((String)PROPERTY_KEY_DATA_PERMISSION_SQL_FILTER, null);
        if (dataPermSqlFilterClassName != null) {
            Class dataPermSqlFilterClass = DWApplicationClassLoader.getInstance().loadClass(dataPermSqlFilterClassName);
            result = (IDWSQLFilter)dataPermSqlFilterClass.newInstance();
        }
        return result;
    }

    private List<IDWSQLFilter> getCustomFilters() throws Exception {
        ArrayList<DWSQLManagementFieldFilter> customFilters = null;
        String dwsqlFilterChianCustom = DWApplicationConfigUtils.getProperty((String)"dwsqlFilterChianCustom");
        if (dwsqlFilterChianCustom != null && dwsqlFilterChianCustom.toLowerCase().startsWith("true:")) {
            String[] parts;
            customFilters = new ArrayList<DWSQLManagementFieldFilter>();
            String customFiltersString = dwsqlFilterChianCustom.substring("true:".length());
            for (String clazzString : parts = customFiltersString.split(",")) {
                Class clazz = DWApplicationClassLoader.getInstance().loadClass(clazzString);
                IDWSQLFilter instance = clazz == DWSQLManagementFieldFilter.class ? DWSQLFilterChainSpringConfig.getDefaultMgmtFieldSQLFilter() : (IDWSQLFilter)clazz.newInstance();
                customFilters.add((DWSQLManagementFieldFilter)instance);
            }
        }
        return customFilters;
    }
}

