/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.sql.BaseDaoException;
import com.digiwin.app.sql.SQLParser;
import java.util.Map;

public class DataTooLongForColumnException
extends BaseDaoException {
    public static final int ERROR_CODE = 1406;
    public static final String DATA_TOO_LONG_FOR_COLUMN_PREFIX = "Data too long for column '";
    public static final String DATA_TOO_LONG_FOR_COLUMN_POSTFIX = "' at";
    public static final int DATA_TOO_LONG_FOR_COLUMN_PREFIX_INDEX = "Data too long for column '".length();

    @Override
    public int getErrorCode() throws Exception {
        return 1406;
    }

    @Override
    public void settingFormat(String message, DWDao dao) throws Exception {
        this.exceptionMessageFormat = "[\u8d44\u6599\u5904\u7406\u5f02\u5e38][\u5b57\u6bb5\u503c\u8fc7\u957f]\u8d44\u6599\u8868=%s(%s)\uff0c\u5b57\u6bb5=%s(%s)\uff0c\u680f\u4f4d\u957f=%s\uff0c\u503c=%s";
    }

    @Override
    public void settingArgument(String message, DWDao dao) throws Exception {
        String tableName = SQLParser.fetchTableName(message);
        String columnName = this.fetchMessage(message);
        DWRdbmsMetadata metadata = this.getMetadata(tableName);
        DWRdbmsField field = (DWRdbmsField)metadata.getField(columnName);
        this.exceptionMessageArgument.add(metadata.getName());
        this.exceptionMessageArgument.add(metadata.getName());
        this.exceptionMessageArgument.add(field.getName());
        this.exceptionMessageArgument.add(field.getName());
        this.exceptionMessageArgument.add(String.valueOf(field.getSize()));
        String value = "\u672a\u77e5";
        if (this.data instanceof Map) {
            Map convertData = (Map)this.data;
            for (Map.Entry dataEntry : convertData.entrySet()) {
                if (!columnName.toLowerCase().equals(((String)dataEntry.getKey()).toLowerCase())) continue;
                value = String.valueOf(dataEntry.getValue());
                break;
            }
        }
        this.exceptionMessageArgument.add(value);
    }

    private String fetchMessage(String message) throws Exception {
        String result = "";
        int leftIndex = message.indexOf(DATA_TOO_LONG_FOR_COLUMN_PREFIX) + DATA_TOO_LONG_FOR_COLUMN_PREFIX_INDEX;
        int rightIndex = message.indexOf(DATA_TOO_LONG_FOR_COLUMN_POSTFIX);
        result = message.substring(leftIndex, rightIndex);
        return result;
    }
}

