/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWRowProcessor;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.metadata.exceptions.DWMetadataNotFoundException;
import com.digiwin.app.sql.CustomizeFieldUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;

public class DWDataTableHandler
implements ResultSetHandler<DWDataTable> {
    private final DWRowProcessor convert = new DWRowProcessor();
    private DWQueryInfo queryInfo;

    public DWDataTableHandler(DWQueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    public DWDataTable handle(ResultSet rs) throws SQLException {
        DWDataTable dataTable = null;
        String tableName = null;
        if (this.queryInfo != null) {
            tableName = this.queryInfo.getTableName();
        }
        if (tableName == null || tableName.isEmpty()) {
            int columnCount = rs.getMetaData().getColumnCount();
            HashSet<String> tableNames = new HashSet<String>();
            for (int i = 1; i <= columnCount; ++i) {
                tableNames.add(rs.getMetaData().getTableName(i));
            }
            tableName = (String)tableNames.iterator().next();
        }
        DWDataSet dataset = new DWDataSet();
        dataTable = dataset.newTable(tableName);
        while (rs.next()) {
            this.handleRow(dataTable, rs);
        }
        this.handleCustFields(dataTable);
        return dataTable;
    }

    public void handleRow(DWDataTable dataTable, ResultSet rs) throws SQLException {
        if (this.queryInfo != null) {
            this.convert.setSelectFields(this.queryInfo.getSelectFields());
        }
        Map<String, Object> orgData = this.convert.toMap(rs);
        dataTable.newRow(orgData);
    }

    private void handleCustFields(DWDataTable dataTable) {
        Map<String, Object> custColumns = null;
        try {
            custColumns = CustomizeFieldUtil.getCustFieldsFromMetadata(dataTable.getName());
        }
        catch (DWMetadataNotFoundException dWMetadataNotFoundException) {
            // empty catch block
        }
        dataTable.setCustColumns(custColumns);
    }
}

