/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWSQLExecutionResult {
    private static final String CATALOG_INSERT = "C";
    private static final String CATALOG_UPDATE = "U";
    private static final String CATALOG_DELETE = "D";
    private Map<String, Map<String, Integer>> countInfo = new HashMap<String, Map<String, Integer>>();
    private Map<String, List<Object>> generatedKeys = new HashMap<String, List<Object>>();
    private String primaryTable = null;

    protected void addInsertCount(String tableName, int count) {
        this.addCount(tableName, CATALOG_INSERT, count);
    }

    protected void addUpdateCount(String tableName, int count) {
        this.addCount(tableName, CATALOG_UPDATE, count);
    }

    protected void addDeleteCount(String tableName, int count) {
        this.addCount(tableName, CATALOG_DELETE, count);
    }

    private void addCount(String tableName, String catalog, int count) {
        Map<String, Integer> catalogCountInfo;
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("tableName is null or empty!");
        }
        tableName = tableName.toLowerCase();
        if (this.countInfo.size() == 0) {
            this.primaryTable = tableName;
        }
        if ((catalogCountInfo = this.countInfo.get(tableName)) == null) {
            catalogCountInfo = new HashMap<String, Integer>();
            this.countInfo.put(tableName, catalogCountInfo);
        }
        if (!catalogCountInfo.containsKey(catalog)) {
            catalogCountInfo.put(catalog, 0);
        }
        int currentCount = catalogCountInfo.get(catalog) + count;
        catalogCountInfo.put(catalog, currentCount);
    }

    public void addGeneratedKeys(String tableName, List<Object> keys) {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("tableName is null or empty!");
        }
        if (keys == null) {
            return;
        }
        String tableKey = tableName.toLowerCase();
        List<Object> currentKeys = this.generatedKeys.get(tableKey);
        if (currentKeys == null) {
            currentKeys = new ArrayList<Object>();
            this.generatedKeys.put(tableKey, currentKeys);
        }
        currentKeys.addAll(keys);
    }

    public List<Object> getGeneratedKeys(String tableName) {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("tableName is null or empty!");
        }
        if (!this.generatedKeys.containsKey(tableName.toLowerCase())) {
            return Collections.emptyList();
        }
        return this.generatedKeys.get(tableName.toLowerCase());
    }

    public Map<String, List<Object>> getGeneratedKeys() {
        return Collections.unmodifiableMap(this.generatedKeys);
    }

    public int getCount() {
        return this.getCountByTable(this.primaryTable);
    }

    public int getInsertCount() {
        return this.getCountByTableCatalog(this.primaryTable, CATALOG_INSERT);
    }

    public int getUpdateCount() {
        return this.getCountByTableCatalog(this.primaryTable, CATALOG_UPDATE);
    }

    public int getDeleteCount() {
        return this.getCountByTableCatalog(this.primaryTable, CATALOG_DELETE);
    }

    private int getCountByTableCatalog(String tableName, String catalog) {
        if (tableName == null || tableName.isEmpty()) {
            return -1;
        }
        if (!this.countInfo.containsKey(tableName.toLowerCase())) {
            return -1;
        }
        Integer count = this.countInfo.get(tableName.toLowerCase()).get(catalog);
        if (count == null) {
            return -1;
        }
        return count;
    }

    public int getAllTablesCount() {
        int totalCount = 0;
        for (Map.Entry<String, Map<String, Integer>> item : this.countInfo.entrySet()) {
            totalCount += item.getValue().values().stream().mapToInt(Integer::intValue).sum();
        }
        return totalCount;
    }

    public int getCountByTable(String tableName) {
        if (tableName == null || tableName.isEmpty()) {
            return -1;
        }
        if (!this.countInfo.containsKey(tableName)) {
            return -1;
        }
        int totalCount = this.countInfo.get(tableName).values().stream().mapToInt(Integer::intValue).sum();
        return totalCount;
    }

    public int getTotalCountByTable(String tableName) {
        if (tableName == null || tableName.isEmpty()) {
            return -1;
        }
        if (!this.countInfo.containsKey(tableName.toLowerCase())) {
            return -1;
        }
        int totalCount = this.countInfo.get(tableName.toLowerCase()).values().stream().mapToInt(Integer::intValue).sum();
        return totalCount;
    }
}

