/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.sql.BaseDaoException;
import com.digiwin.app.sql.SQLParser;

public class ColumnValueIsNullException
extends BaseDaoException {
    public static final int ERROR_CODE = 1048;
    public static final String COLUMN_VALUE_IS_NULL_PREFIX = "Column '";
    public static final String COLUMN_VALUE_IS_NULL_POSTFIX = "' cannot be null";
    public static final int COLUMN_VALUE_IS_NULL_PREFIX_INDEX = "Column '".length();

    @Override
    public int getErrorCode() throws Exception {
        return 1048;
    }

    @Override
    public void settingFormat(String message, DWDao dao) throws Exception {
        this.exceptionMessageFormat = "[\u8d44\u6599\u5904\u7406\u5f02\u5e38][\u5b57\u6bb5\u503c\u4e0d\u53ef\u4e3a\u7a7a]\u8d44\u6599\u8868=%s(%s)\uff0c\u5b57\u6bb5=%s(%s)";
    }

    @Override
    public void settingArgument(String message, DWDao dao) throws Exception {
        String tableName = SQLParser.fetchTableName(message);
        String columnName = this.fetchMessage(message);
        DWRdbmsMetadata metadata = this.getMetadata(tableName);
        DWRdbmsField field = (DWRdbmsField)metadata.getField(columnName);
        this.exceptionMessageArgument.add(metadata.getName());
        this.exceptionMessageArgument.add(metadata.getName());
        this.exceptionMessageArgument.add(field.getName());
        this.exceptionMessageArgument.add(field.getName());
    }

    private String fetchMessage(String message) throws Exception {
        String result = "";
        int leftIndex = message.indexOf(COLUMN_VALUE_IS_NULL_PREFIX) + COLUMN_VALUE_IS_NULL_PREFIX_INDEX;
        int rightIndex = message.indexOf(COLUMN_VALUE_IS_NULL_POSTFIX);
        result = message.substring(leftIndex, rightIndex);
        return result;
    }
}

