/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.sql.BaseDaoException;
import com.digiwin.app.sql.SQLParser;

public class DataDuplicateException
extends BaseDaoException {
    public static final int ERROR_CODE = 1062;
    public static final String DUPLICATE_ENTRY_PREFIX = "Duplicate entry '";
    public static final String DUPLICATE_ENTRY_POSTFIX = "' for key";
    public static final int DUPLICATE_ENTRY_PREFIX_INDEX = "Duplicate entry '".length();

    @Override
    public int getErrorCode() throws Exception {
        return 1062;
    }

    @Override
    public void settingFormat(String message, DWDao dao) throws Exception {
        this.exceptionMessageFormat = "[\u8d44\u6599\u5904\u7406\u5f02\u5e38][\u8d44\u6599\u91cd\u590d]\u8d44\u6599\u8868=%s(%s)\uff0c\u503c=%s";
    }

    @Override
    public void settingArgument(String message, DWDao dao) throws Exception {
        String tableName = SQLParser.fetchTableName(message);
        String duplicateEntry = this.fetchMessage(message);
        DWRdbmsMetadata metadata = this.getMetadata(tableName);
        this.exceptionMessageArgument.add(metadata.getName());
        this.exceptionMessageArgument.add(metadata.getName());
        this.exceptionMessageArgument.add(duplicateEntry);
    }

    private String fetchMessage(String message) throws Exception {
        String result = "";
        int leftIndex = message.indexOf(DUPLICATE_ENTRY_PREFIX) + DUPLICATE_ENTRY_PREFIX_INDEX;
        int rightIndex = message.indexOf(DUPLICATE_ENTRY_POSTFIX);
        result = message.substring(leftIndex, rightIndex);
        return result;
    }
}

