/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.sql.BaseDaoException;

public class TableNoExistException
extends BaseDaoException {
    public static final int ERROR_CODE = 1146;
    public static final String TABLE_NO_EXIST_PREFIX = "Table '";
    public static final String TABLE_NO_EXIST_POSTFIX = "' doesn't exist";
    public static final int TABLE_NO_EXIST_PREFIX_INDEX = "Table '".length();

    @Override
    public int getErrorCode() throws Exception {
        return 1146;
    }

    @Override
    public void settingFormat(String message, DWDao dao) throws Exception {
        this.exceptionMessageFormat = "[\u8d44\u6599\u5904\u7406\u5f02\u5e38][\u8d44\u6599\u8868\u4e0d\u5b58\u5728]\u8d44\u6599\u8868=%s";
    }

    @Override
    public void settingArgument(String message, DWDao dao) throws Exception {
        String tableName = this.fetchMessage(message);
        this.exceptionMessageArgument.add(tableName);
    }

    private String fetchMessage(String message) throws Exception {
        String result = "";
        int leftIndex = message.indexOf(TABLE_NO_EXIST_PREFIX) + TABLE_NO_EXIST_PREFIX_INDEX;
        int rightIndex = message.indexOf(TABLE_NO_EXIST_POSTFIX);
        result = message.substring(leftIndex, rightIndex);
        return result;
    }
}

