/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWBatchDataRowSqlInfo;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWDataRowSqlInfo;
import com.digiwin.app.dao.DWDataSetSqlInfo;
import com.digiwin.app.dao.DWDataTableHandler;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryBeanResult;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.constraint.DWDeleteConstraint;
import com.digiwin.app.dao.dialect.DWCommonSQLDialect;
import com.digiwin.app.dao.dialect.DWMySQLDialect;
import com.digiwin.app.dao.dialect.DWSQLDialect;
import com.digiwin.app.dao.filter.DWSQLManagementFieldFilter;
import com.digiwin.app.data.DWCascadeDeletingInfo;
import com.digiwin.app.data.DWCascadeQueryInfo;
import com.digiwin.app.data.DWDataOptimisticLockingInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCondition;
import com.digiwin.app.data.DWDataRowInfoUtils;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.DWSQLOptionsBuilder;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.data.exceptions.DWDataOptimisticLockingException;
import com.digiwin.app.data.exceptions.ExecuteException;
import com.digiwin.app.data.exceptions.SetDialectException;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.metadata.rdbms.DWRdbmsRelationshipAttribute;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.utils.DBUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.GenerousBeanProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWDaoImpl
implements DWDao {
    private static Log log = LogFactory.getLog(DWDaoImpl.class);
    private boolean mapUnderscoreToCamelCase = true;
    private boolean insertDefaultValueFromMetadata = false;
    private DWSQLDialect dialect;
    QueryRunner queryRunner;

    public void setMapUnderscoreToCamelCase(boolean mapUnderscoreToCamelCase) {
        this.mapUnderscoreToCamelCase = mapUnderscoreToCamelCase;
    }

    public void setInsertDefaultValueFromMetadata(boolean insertDefaultValueFromMetadata) {
        this.insertDefaultValueFromMetadata = insertDefaultValueFromMetadata;
    }

    public DWDaoImpl(QueryRunner queryRunner) {
        this.queryRunner = queryRunner;
    }

    public QueryRunner getQueryRunner() {
        return this.getQueryRunner(null);
    }

    public QueryRunner getQueryRunner(IDWSQLOptions iOption) {
        return this.queryRunner;
    }

    @Override
    public <T> List<T> select(Class<T> clazz, String statement, Object ... params) {
        BasicRowProcessor rowProcessor = new BasicRowProcessor((BeanProcessor)new GenerousBeanProcessor());
        return this.select(clazz, (RowProcessor)rowProcessor, statement, params);
    }

    @Override
    public <T> List<T> select(Class<T> clazz, RowProcessor rowProcessor, String statement, Object ... params) {
        return this.select(null, clazz, rowProcessor, statement, params);
    }

    @Override
    public <T> List<T> select(IDWSQLOptions options, Class<T> clazz, String statement, Object ... params) {
        BasicRowProcessor rowProcessor = new BasicRowProcessor((BeanProcessor)new GenerousBeanProcessor());
        return this.select(options, clazz, (RowProcessor)rowProcessor, statement, params);
    }

    @Override
    public <T> List<T> select(IDWSQLOptions options, Class<T> clazz, RowProcessor rowProcessor, String statement, Object ... params) {
        if (options == null) {
            options = DWCommonSQLDialect.createDefaultOption();
        }
        if (options instanceof DWDataSetOperationOption) {
            ((DWDataSetOperationOption)options).setManagementFieldEnabled(false);
        } else {
            options.set(DWSQLManagementFieldFilter.OPTION_MANAGEMENT_FIELD_ENABLED, false);
        }
        DWSqlInfo sqlInfo = this.getDialect().parse(options, statement, params);
        statement = sqlInfo.getSql();
        params = sqlInfo.getParameters();
        this.logSqlExecutingInfo(options, sqlInfo);
        BeanListHandler beanListHandler = new BeanListHandler(clazz, rowProcessor);
        List result = new ArrayList();
        try {
            QueryRunner queryRunner = this.getQueryRunner(options);
            result = (List)queryRunner.query(statement, (ResultSetHandler)beanListHandler, params);
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> select(String statement, Object ... params) {
        return this.select((IDWSQLOptions)null, statement, params);
    }

    @Override
    public List<Map<String, Object>> select(IDWSQLOptions options, String statement, Object ... params) {
        if (options == null) {
            options = DWCommonSQLDialect.createDefaultOption();
        }
        if (options instanceof DWDataSetOperationOption) {
            ((DWDataSetOperationOption)options).setManagementFieldEnabled(false);
        } else {
            options.set(DWSQLManagementFieldFilter.OPTION_MANAGEMENT_FIELD_ENABLED, false);
        }
        DWSqlInfo sqlInfo = this.getDialect().parse(options, statement, params);
        statement = sqlInfo.getSql();
        params = sqlInfo.getParameters();
        this.logSqlExecutingInfo(options, sqlInfo);
        ArrayList<Map<String, Object>> result = new ArrayList();
        try {
            QueryRunner queryRunner = this.getQueryRunner(options);
            result = (List)queryRunner.query(statement, (ResultSetHandler)new MapListHandler(), params);
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        return result;
    }

    public void setDialectClassName(String dialectClass) {
        Class<?> dialectClazz = null;
        try {
            dialectClazz = this.getClass().getClassLoader().loadClass(dialectClass);
        }
        catch (ClassNotFoundException e) {
            this.logStackTrace(e);
            throw new SetDialectException(e);
        }
        try {
            this.dialect = (DWSQLDialect)dialectClazz.newInstance();
        }
        catch (InstantiationException e) {
            this.logStackTrace(e);
            throw new SetDialectException(e);
        }
        catch (IllegalAccessException e) {
            this.logStackTrace(e);
            throw new SetDialectException(e);
        }
    }

    public void setDialect(DWSQLDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect is null!");
        }
        this.dialect = dialect;
    }

    public DWSQLDialect getDialect() {
        if (this.dialect == null) {
            this.dialect = new DWMySQLDialect();
        }
        return this.dialect;
    }

    @Override
    public int update(String statement, Object ... params) {
        return this.update(null, statement, params);
    }

    @Override
    public int update(IDWSQLOptions options, String statement, Object ... params) {
        DWSqlInfo sqlInfo = this.getDialect().parse(options, statement, params);
        statement = sqlInfo.getSql();
        params = sqlInfo.getParameters();
        this.logSqlExecutingInfo(options, sqlInfo);
        int result = 0;
        try {
            QueryRunner queryRunner = this.getQueryRunner(options);
            result = queryRunner.update(statement, params);
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        return result;
    }

    @Override
    @Deprecated
    public DWDataSet select(DWQueryInfo queryInfo, String sql) {
        return this.select(queryInfo, sql, new DWDataSetOperationOption());
    }

    @Override
    @Deprecated
    public DWDataSet select(DWQueryInfo queryInfo, String sql, DWDataSetOperationOption option) {
        if (queryInfo instanceof DWPagableQueryInfo) {
            DWPaginationQueryResult result = this.selectWithPage((DWPagableQueryInfo)queryInfo, sql, option);
            return (DWDataSet)result.getData();
        }
        DWDataTableHandler dwDataTableHandler = new DWDataTableHandler(queryInfo);
        DWDataTable dataTable = this.select(queryInfo, sql, option, dwDataTableHandler);
        this.cascadeSelect(dataTable, option);
        return dataTable.getDataSet();
    }

    private void cascadeSelect(DWDataTable dataTable, DWDataSetOperationOption option) {
        if (option == null) {
            return;
        }
        String primaryTableName = dataTable.getName();
        List<DWCascadeQueryInfo> queryList = option.getCascadingQueryList();
        if (queryList.size() == 0) {
            return;
        }
        DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)primaryTableName, DWRdbmsMetadata.class);
        Collection relations = metadata.getAttributes(DWRdbmsRelationshipAttribute.class);
        List cascadeList = queryList.stream().filter(item -> primaryTableName.equals(item.getPrimary())).collect(Collectors.toList());
        for (DWCascadeQueryInfo cascadTarget : cascadeList) {
            String referenceName = cascadTarget.getReference();
            DWRdbmsRelationshipAttribute targetAttribute = relations.stream().filter(attr -> attr.getDetailTableName().equals(referenceName)).findFirst().get();
            if (targetAttribute == null) {
                throw new DWDataException(String.format("cascade Query reference(%s) is not found in metadata", referenceName));
            }
            this.cascadeSelect(dataTable, cascadTarget, targetAttribute, option);
        }
    }

    private void cascadeSelect(DWDataTable dataTable, DWCascadeQueryInfo cascadeQueryInfo, DWRdbmsRelationshipAttribute relation, DWDataSetOperationOption option) {
        DWQueryInfo userdefinedQueryInfo = cascadeQueryInfo.getQueryInfo();
        dataTable.getRows().stream().forEach(row -> {
            DWRdbmsMetadata relationTableMetadata;
            boolean autoCaculateMaxSeq;
            DWQueryInfo rowQueryInfo;
            boolean isPagableQueryInfo = userdefinedQueryInfo instanceof DWPagableQueryInfo;
            DWQueryInfo dWQueryInfo = rowQueryInfo = isPagableQueryInfo ? new DWPagableQueryInfo() : new DWQueryInfo();
            if (isPagableQueryInfo) {
                DWPagableQueryInfo userdefinedPagableQueryInfo = (DWPagableQueryInfo)userdefinedQueryInfo;
                DWQueryInfo rowPagableQueryInfo = rowQueryInfo;
                ((DWPagableQueryInfo)rowPagableQueryInfo).setPageSize(userdefinedPagableQueryInfo.getPageSize());
                ((DWPagableQueryInfo)rowPagableQueryInfo).setPageNumber(userdefinedPagableQueryInfo.getPageNumber());
            }
            this.addRelationConditions((DWDataRow)row, relation, rowQueryInfo);
            rowQueryInfo.getOrderfields().addAll(userdefinedQueryInfo.getOrderfields());
            rowQueryInfo.setSelectFields(userdefinedQueryInfo.getSelectFields());
            if (userdefinedQueryInfo.getCondition() != null) {
                DWQueryCondition userDefinedCondition = userdefinedQueryInfo.getCondition().clone();
                rowQueryInfo.getCondition().addCondition(userDefinedCondition);
            }
            String relationTableName = relation.getDetailTableName();
            boolean bl = autoCaculateMaxSeq = option.isCalculateMaxSeqEnabled() && option.getCalculateMaxSeqFieldName() != null && !option.getCalculateMaxSeqFieldName().isEmpty();
            if (autoCaculateMaxSeq && !(relationTableMetadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)relationTableName, DWRdbmsMetadata.class)).hasField(option.getCalculateMaxSeqFieldName())) {
                autoCaculateMaxSeq = false;
            }
            try {
                rowQueryInfo.setTableName(relation.getDetailTableName());
                DWDataSet referenceDataset = null;
                if (isPagableQueryInfo) {
                    DWPaginationQueryResult paginationResult = this.selectWithPage((DWPagableQueryInfo)rowQueryInfo, option);
                    referenceDataset = paginationResult.getDataSet();
                    DWDataRowInfoUtils.setChildPageInfo(row, relation.getDetailTableName(), paginationResult);
                    if (autoCaculateMaxSeq) {
                        DWQueryInfo queryMaxSqlInfo = new DWQueryInfo();
                        queryMaxSqlInfo.setTableName(relation.getDetailTableName());
                        queryMaxSqlInfo.setSelectFields("max(" + option.getCalculateMaxSeqFieldName() + ") as maxSeq");
                        this.addRelationConditions((DWDataRow)row, relation, queryMaxSqlInfo);
                        DWDataRow maxRow = this.selectOne(queryMaxSqlInfo, option);
                        Object maxSeqSourceValue = maxRow.get("maxSeq");
                        long maxSeq = maxSeqSourceValue == null ? 0L : Long.parseLong(maxSeqSourceValue.toString());
                        DWDataRowInfoUtils.setChildSeqInfo(row, relation.getDetailTableName(), option.getCalculateMaxSeqFieldName(), maxSeq);
                    }
                } else {
                    referenceDataset = this.select(rowQueryInfo, null, option);
                    if (autoCaculateMaxSeq) {
                        long maxSeq = this.getMaxSeqInTable(referenceDataset.getTable(relationTableName), option.getCalculateMaxSeqFieldName());
                        DWDataRowInfoUtils.setChildSeqInfo(row, relationTableName, option.getCalculateMaxSeqFieldName(), maxSeq);
                    }
                }
                row.set(relation.getDetailTableName(), (Object)referenceDataset);
            }
            catch (Exception e) {
                this.logStackTrace(e);
                throw new RuntimeException(e);
            }
        });
    }

    private long getMaxSeqInTable(DWDataTable table, String seqFieldName) {
        long maxSeq = 0L;
        long seqLongValue = 0L;
        for (DWDataRow row : table.getRows()) {
            Object seqValue = row.get(seqFieldName);
            if (seqValue == null || maxSeq >= (seqLongValue = Long.parseLong(seqValue.toString()))) continue;
            maxSeq = seqLongValue;
        }
        return maxSeq;
    }

    private void addRelationConditions(DWDataRow primaryRow, DWRdbmsRelationshipAttribute relationAttribute, DWQueryInfo referenceQueryInfo) {
        Map joinColumns = relationAttribute.getJoinColumns();
        for (Map.Entry item : joinColumns.entrySet()) {
            String primaryField = (String)item.getKey();
            String referenceField = (String)item.getValue();
            Object value = primaryRow.get(primaryField);
            referenceQueryInfo.addEqualInfo(referenceField, value);
        }
    }

    @Override
    @Deprecated
    public DWDataRow selectOne(DWQueryInfo queryInfo, String sql) {
        return this.selectOne(queryInfo, sql, null);
    }

    @Override
    @Deprecated
    public DWDataRow selectOne(DWQueryInfo queryInfo, String sql, DWDataSetOperationOption option) {
        DWDataSet dataset = this.select(queryInfo, sql, option);
        DWDataTable primaryTable = dataset.getTables().getPrimaryTable();
        int size = primaryTable.getRows().size();
        if (size > 1) {
            throw new DWDataException("13015", "There are more than one row in dataset!");
        }
        if (size == 0) {
            return null;
        }
        return primaryTable.getRow(0);
    }

    @Override
    @Deprecated
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo, String sql) {
        return this.selectWithPage(pagableQueryInfo, sql, new DWDataSetOperationOption());
    }

    @Override
    @Deprecated
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo, String sql, DWDataSetOperationOption option) {
        int totalCount = this.selectTotalCount(pagableQueryInfo, sql, option);
        DWDataTableHandler dwDataTableHandler = new DWDataTableHandler(pagableQueryInfo);
        DWDataTable dataTable = this.selectWithPage(pagableQueryInfo, sql, option, dwDataTableHandler);
        this.cascadeSelect(dataTable, option);
        DWDataSet dataset = dataTable.getDataSet();
        DWPaginationQueryResult paginationQueryResult = new DWPaginationQueryResult(pagableQueryInfo.getPageSize(), totalCount);
        paginationQueryResult.setCurrentPage(pagableQueryInfo.getPageNumber(), dataset);
        return paginationQueryResult;
    }

    @Override
    public DWSQLExecutionResult execute(DWDataSet dataset) {
        return this.execute(dataset, null);
    }

    private void logSqlExecutingInfo(String sql, Object ... params) {
        log.info((Object)("[SQL.statement]" + sql));
        log.info((Object)("[SQL.params]" + (params == null ? "[]" : Arrays.asList(params))));
    }

    @Deprecated
    private void logSqlExecutingInfo(DWSqlInfo sqlInfo) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug((Object)("[SQL.statement]" + sqlInfo.getSql()));
        StringBuilder parameterInfo = new StringBuilder();
        Object[] parameters = sqlInfo.getParameters();
        int seq = 0;
        int count = parameters.length;
        for (Object p : parameters) {
            parameterInfo.append(p);
            if (p == null) {
                parameterInfo.append("(Unknown)");
            } else {
                parameterInfo.append("(").append(p.getClass().getSimpleName()).append(")");
            }
            if (++seq == count) continue;
            parameterInfo.append(", ");
        }
        log.debug((Object)("[SQL.params]" + parameterInfo.toString()));
    }

    private void logSqlExecutingInfo(IDWSQLOptions option, DWSqlInfo sqlInfo) {
        StringBuilder parameterInfo = new StringBuilder();
        Object[] parameters = sqlInfo.getParameters();
        int seq = 0;
        int count = parameters.length;
        for (Object p : parameters) {
            parameterInfo.append(p);
            if (p == null) {
                parameterInfo.append("(Unknown)");
            } else {
                parameterInfo.append("(").append(p.getClass().getSimpleName()).append(")");
            }
            if (++seq == count) continue;
            parameterInfo.append(", ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[SQL.statement]" + sqlInfo.getSql()));
            log.debug((Object)("[SQL.params]" + parameterInfo.toString()));
        }
        boolean configOfServiceLogForOperate = false;
        Map operateLogMap = DWServiceContext.getContext().getOperateLog();
        if (MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("isLogRecord") && ((Boolean)operateLogMap.get("isLogRecord")).booleanValue()) {
            configOfServiceLogForOperate = true;
        }
        if (configOfServiceLogForOperate) {
            boolean combinedConfigValueOfSqlLogForOperate = true;
            boolean collectSqlLogForOperate = false;
            boolean daoOptionValueOfOperateLogEnabled = true;
            if (MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("isLogSqlRecord")) {
                combinedConfigValueOfSqlLogForOperate = (Boolean)operateLogMap.get("isLogSqlRecord");
            }
            if (combinedConfigValueOfSqlLogForOperate) {
                collectSqlLogForOperate = option != null ? (daoOptionValueOfOperateLogEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)option.get(DWSQLOptionsBuilder.OPTION_LOG_OPERATION_ENABLED)), (boolean)true)) : true;
            }
            if (collectSqlLogForOperate) {
                this.operateSqlLogCollector(sqlInfo.getSql(), parameters);
            }
            log.debug((Object)String.format("collectSqlLogForOperate=%b (configOfServiceLogForOperate=%b, combinedConfigValueOfSqlLogForOperate=%b, daoOptionValueOfOperateLogEnabled=%s !)", collectSqlLogForOperate, configOfServiceLogForOperate, combinedConfigValueOfSqlLogForOperate, daoOptionValueOfOperateLogEnabled));
        }
    }

    @Override
    public DWSQLExecutionResult execute(DWDataSet dataset, DWDataSetOperationOption option) {
        if (null == dataset) {
            throw new IllegalArgumentException("dataset cannot be null!!");
        }
        if (option == null) {
            option = new DWDataSetOperationOption();
        }
        option.set("insertDefaultValueFromMetadata", this.insertDefaultValueFromMetadata);
        String operation = "";
        DWDataSetSqlInfo datasqlInfo = this.getDialect().parse(dataset, option);
        DWSQLExecutionResult resultInfo = new DWSQLExecutionResult();
        String tableName = "";
        DWDataRowSqlInfo rowSqlInfoException = null;
        int index = -1;
        try {
            Iterator iterator = datasqlInfo.iterator();
            while (iterator.hasNext()) {
                DWDataRowSqlInfo rowSqlInfo;
                rowSqlInfoException = rowSqlInfo = (DWDataRowSqlInfo)iterator.next();
                ++index;
                this.logSqlExecutingInfo(option, rowSqlInfo);
                operation = rowSqlInfo.getState();
                tableName = rowSqlInfo.getTableName();
                switch (operation) {
                    case "C": {
                        int count;
                        rowSqlInfo.updateAutoIncrementRefColumnValues(option);
                        boolean returnGeneratedKeys = option.getTableStatementOption().isReturnGeneratedKeys(tableName);
                        if (rowSqlInfo.getMetadata().getAutoIncrement() != null && returnGeneratedKeys) {
                            List<Object> generatedKeys = this.insertReturnGeneratedKeys(rowSqlInfo, option);
                            count = generatedKeys.size();
                            resultInfo.addGeneratedKeys(tableName, generatedKeys);
                        } else {
                            count = this.insert(rowSqlInfo, option);
                        }
                        resultInfo.addInsertCount(tableName, count);
                        break;
                    }
                    case "U": {
                        int count = this.update(rowSqlInfo, option);
                        resultInfo.addUpdateCount(tableName, count);
                        break;
                    }
                    case "D": {
                        DWDeleteConstraint deleteConstraint = new DWDeleteConstraint();
                        deleteConstraint.check(rowSqlInfo, option);
                        this.cascadeDelete(rowSqlInfo, option, resultInfo);
                        int count = this.delete(rowSqlInfo);
                        resultInfo.addDeleteCount(tableName, count);
                        break;
                    }
                    default: {
                        throw new DWDataException("13008", String.format("This Operation[%s] is unknown!", operation));
                    }
                }
                rowSqlInfo.persist();
            }
        }
        catch (DWDataException e) {
            e.rethrow((Throwable)((Object)e), tableName, operation, datasqlInfo, index);
        }
        catch (Exception e) {
            new DWDataException().rethrow("13029", e, tableName, operation, datasqlInfo, index);
        }
        return resultInfo;
    }

    public int insert(DWSqlInfo sqlInfo) {
        int result = this.insert(sqlInfo, null);
        return result;
    }

    public int insert(DWSqlInfo sqlInfo, DWDataSetOperationOption option) {
        int result = 0;
        if (sqlInfo instanceof DWBatchDataRowSqlInfo) {
            DWBatchDataRowSqlInfo batchSqlInfo = (DWBatchDataRowSqlInfo)sqlInfo;
            int[] batchResult = new int[]{};
            try {
                QueryRunner queryRunner = this.getQueryRunner(option);
                batchResult = queryRunner.batch(sqlInfo.getSql(), batchSqlInfo.getBatchParameters());
            }
            catch (SQLException e) {
                this.logStackTrace(e);
                throw new ExecuteException(e);
            }
            result = batchResult.length > 0 && batchResult[0] == -2 ? -2 : Arrays.stream(batchResult).sum();
        } else {
            try {
                QueryRunner queryRunner = this.getQueryRunner(option);
                result = queryRunner.update(sqlInfo.getSql(), sqlInfo.getParameters());
            }
            catch (SQLException e) {
                this.logStackTrace(e);
                throw new ExecuteException(e);
            }
        }
        return result;
    }

    public List<Object> insertReturnGeneratedKeys(DWSqlInfo sqlInfo) {
        List<Object> generatedKeys = this.insertReturnGeneratedKeys(sqlInfo, null);
        return generatedKeys;
    }

    public List<Object> insertReturnGeneratedKeys(DWSqlInfo sqlInfo, DWDataSetOperationOption option) {
        List insertResult;
        boolean isDataRowSqlInfo = sqlInfo instanceof DWDataRowSqlInfo;
        boolean isBatchDataRowSqlInfo = sqlInfo instanceof DWBatchDataRowSqlInfo;
        if (sqlInfo instanceof DWBatchDataRowSqlInfo) {
            DWBatchDataRowSqlInfo batchInfo = (DWBatchDataRowSqlInfo)sqlInfo;
            try {
                QueryRunner queryRunner = this.getQueryRunner(option);
                insertResult = (List)queryRunner.insertBatch(sqlInfo.getSql(), (ResultSetHandler)new MapListHandler(), batchInfo.getBatchParameters());
            }
            catch (SQLException e) {
                this.logStackTrace(e);
                throw new ExecuteException(e);
            }
        }
        try {
            QueryRunner queryRunner = this.getQueryRunner(option);
            insertResult = (List)queryRunner.insert(sqlInfo.getSql(), (ResultSetHandler)new MapListHandler(), sqlInfo.getParameters());
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        List<Object> generatedKeys = null;
        if (insertResult == null) {
            generatedKeys = Collections.emptyList();
        } else {
            String key = DBUtils.getGeneratedKeyColumnName((String)"insert_id");
            generatedKeys = insertResult.stream().map(i -> i.get(key)).collect(Collectors.toList());
        }
        if (isDataRowSqlInfo) {
            DWDataRowSqlInfo rowSqlInfo = (DWDataRowSqlInfo)sqlInfo;
            if (isBatchDataRowSqlInfo) {
                DWBatchDataRowSqlInfo batchInfo = (DWBatchDataRowSqlInfo)sqlInfo;
                batchInfo.setGeneratedKeys(generatedKeys);
            } else if (generatedKeys.size() == 1) {
                rowSqlInfo.getRow().set(rowSqlInfo.getMetadata().getAutoIncrement(), generatedKeys.get(0));
            } else if (generatedKeys.size() > 1 && DWDataRowCondition.getInsertFrom(rowSqlInfo.getRow()) == null) {
                throw new DWDataException("13011", String.format("This row(%s) generate more than one keys!", rowSqlInfo.getRow()));
            }
        }
        return generatedKeys;
    }

    private int updateBatch(DWBatchDataRowSqlInfo batchSqlInfo) {
        int[] result = new int[]{};
        try {
            QueryRunner queryRunner = this.getQueryRunner();
            result = queryRunner.batch(batchSqlInfo.getSql(), batchSqlInfo.getBatchParameters());
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        if (batchSqlInfo.hasLockingInfo()) {
            for (int i = 0; i < batchSqlInfo.getRowCount(); ++i) {
                DWDataOptimisticLockingInfo lockingInfo = batchSqlInfo.getLockingInfo(i);
                if (lockingInfo == null || result[i] == 1) continue;
                throw new DWDataOptimisticLockingException(lockingInfo);
            }
        }
        return Arrays.stream(result).sum();
    }

    public int update(DWSqlInfo sqlInfo) {
        int result = this.update(sqlInfo, null);
        return result;
    }

    public int update(DWSqlInfo sqlInfo, DWDataSetOperationOption option) {
        if (sqlInfo instanceof DWBatchDataRowSqlInfo) {
            return this.updateBatch((DWBatchDataRowSqlInfo)sqlInfo);
        }
        int result = 0;
        try {
            QueryRunner queryRunner = this.getQueryRunner(option);
            result = queryRunner.update(sqlInfo.getSql(), sqlInfo.getParameters());
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        DWDataOptimisticLockingInfo lockingInfo = sqlInfo.getLockingInfo();
        if (lockingInfo != null && result != 1) {
            throw new DWDataOptimisticLockingException(lockingInfo);
        }
        return result;
    }

    private void cascadeDelete(DWDataRowSqlInfo sqlInfo, DWDataSetOperationOption option, DWSQLExecutionResult resultInfo) {
        List<DWCascadeDeletingInfo> deleteList = option.getCascadingDeletingList();
        if (deleteList.size() == 0) {
            return;
        }
        DWDataRow dataRow = sqlInfo.getRow();
        DWDataTable dataTable = dataRow.getDataTable();
        String primaryTableName = dataTable.getName();
        CascadeDeletingInstruction instruction = new CascadeDeletingInstruction(primaryTableName, option, resultInfo);
        if (!instruction.hasReferenceCascadeSetting()) {
            return;
        }
        if (sqlInfo instanceof DWBatchDataRowSqlInfo) {
            throw new DWDataException("Batch Mode is not support cascade deleting.");
        }
        for (DWCascadeDeletingInfo cascadeTarget : instruction.getCascadeDeletingList()) {
            this.cascadeDelete(dataRow, cascadeTarget, instruction);
        }
    }

    private boolean cascadeDelete(DWDataRow sourceRow, DWCascadeDeletingInfo cascadeDeleteInfo, CascadeDeletingInstruction instruction) {
        String primaryTableName = cascadeDeleteInfo.getReference();
        CascadeDeletingInstruction innerInstruction = new CascadeDeletingInstruction(primaryTableName, instruction.option, instruction.resultInfo);
        boolean hasReferenceCascadeSetting = innerInstruction.hasReferenceCascadeSetting();
        if (hasReferenceCascadeSetting) {
            HashMap<DWCascadeDeletingInfo, Boolean> cascadeDeleteReference = new HashMap<DWCascadeDeletingInfo, Boolean>();
            DWDataTable refDataTable = this.queryCascadeDeletingDataRows(sourceRow, cascadeDeleteInfo, instruction);
            for (DWDataRow dataRow : refDataTable.getRows()) {
                for (DWCascadeDeletingInfo cascadeTarget : innerInstruction.getCascadeDeletingList()) {
                    if (cascadeDeleteReference.containsKey(cascadeTarget) && !((Boolean)cascadeDeleteReference.get(cascadeTarget)).booleanValue()) continue;
                    cascadeDeleteReference.put(cascadeTarget, this.cascadeDelete(dataRow, cascadeTarget, innerInstruction));
                }
            }
            log.info((Object)String.format(">Cascade delete (%s)...source row (%s)", primaryTableName, sourceRow));
            int count = refDataTable.getRows().size();
            for (int i = count - 1; i >= 0; --i) {
                refDataTable.getRows().deleteAt(i);
            }
            DWSQLExecutionResult result = this.execute(refDataTable.getDataSet());
            if (result instanceof DWSQLExecutionResult) {
                DWSQLExecutionResult cascadeDeleteResult = result;
                int deleteCount = cascadeDeleteResult.getDeleteCount();
                innerInstruction.resultInfo.addDeleteCount(refDataTable.getName(), deleteCount);
            }
        } else {
            DWRdbmsRelationshipAttribute relation = instruction.getMappingAttribute(cascadeDeleteInfo);
            DWQueryCondition rowDeleteCondition = new DWQueryCondition();
            for (Map.Entry item : relation.getJoinColumns().entrySet()) {
                rowDeleteCondition.addEqualInfo((String)item.getValue(), sourceRow.get((String)item.getKey()));
            }
            DWQueryCondition userDefinedCondition = cascadeDeleteInfo.getCondition().clone();
            rowDeleteCondition.addCondition(userDefinedCondition);
            DWSqlInfo sqlInfo = this.getDialect().parseDeleteSql(primaryTableName, rowDeleteCondition);
            log.info((Object)String.format(">Cascade delete (%s)...source row (%s)", primaryTableName, sourceRow));
            this.logSqlExecutingInfo(instruction.option, sqlInfo);
            int delectCount = this.delete(sqlInfo);
            instruction.resultInfo.addDeleteCount(primaryTableName, delectCount);
        }
        return hasReferenceCascadeSetting;
    }

    private DWDataTable queryCascadeDeletingDataRows(DWDataRow sourceRow, DWCascadeDeletingInfo cascadeTarget, CascadeDeletingInstruction instruction) {
        DWRdbmsRelationshipAttribute relation = instruction.getMappingAttribute(cascadeTarget);
        Map joinColumns = relation.getJoinColumns();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ").append(relation.getDetailTableName());
        DWQueryInfo queryInfo = new DWQueryInfo();
        for (Map.Entry item : joinColumns.entrySet()) {
            Object value = sourceRow.get((String)item.getKey());
            queryInfo.addEqualInfo((String)item.getValue(), value);
        }
        queryInfo.getCondition().addCondition(cascadeTarget.getCondition().clone());
        DWDataSet dataset = this.select(queryInfo, sql.toString(), instruction.option);
        DWDataTable dataTable = dataset.getTable(relation.getDetailTableName());
        return dataTable;
    }

    public int delete(DWSqlInfo sqlInfo) {
        int result = this.delete(sqlInfo, null);
        return result;
    }

    public int delete(DWSqlInfo sqlInfo, DWDataSetOperationOption option) {
        if (sqlInfo instanceof DWBatchDataRowSqlInfo) {
            return this.updateBatch((DWBatchDataRowSqlInfo)sqlInfo);
        }
        int result = 0;
        try {
            QueryRunner queryRunner = this.getQueryRunner(option);
            result = queryRunner.update(sqlInfo.getSql(), sqlInfo.getParameters());
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        DWDataOptimisticLockingInfo lockingInfo = sqlInfo.getLockingInfo();
        if (lockingInfo != null && result != 1) {
            throw new DWDataOptimisticLockingException(lockingInfo);
        }
        return result;
    }

    @Override
    public DWDataSet select(DWQueryInfo queryInfo) {
        return this.select(queryInfo, null, new DWDataSetOperationOption());
    }

    @Override
    public DWDataSet select(DWQueryInfo queryInfo, DWDataSetOperationOption option) {
        return this.select(queryInfo, null, option);
    }

    @Override
    public DWDataRow selectOne(DWQueryInfo queryInfo) {
        DWDataSetOperationOption option = null;
        return this.selectOne(queryInfo, option);
    }

    @Override
    public DWDataRow selectOne(DWQueryInfo queryInfo, DWDataSetOperationOption option) {
        String sql = null;
        return this.selectOne(queryInfo, sql, option);
    }

    @Override
    public <T> List<T> select(Class<T> clazz, DWQueryInfo queryInfo) {
        return this.select(clazz, queryInfo, null);
    }

    @Override
    public <T> List<T> select(Class<T> clazz, DWQueryInfo queryInfo, DWDataSetOperationOption option) {
        BeanListHandler beanListHandler = new BeanListHandler(clazz, this.getRowProcessor());
        return (List)this.select(queryInfo, null, option, (ResultSetHandler<T>)beanListHandler);
    }

    @Override
    public <T> T selectOne(Class<T> clazz, DWQueryInfo queryInfo) {
        return this.selectOne(clazz, queryInfo, null);
    }

    @Override
    public <T> T selectOne(Class<T> clazz, DWQueryInfo queryInfo, DWDataSetOperationOption option) {
        BeanHandler beanHandler = new BeanHandler(clazz, this.getRowProcessor());
        return this.select(queryInfo, null, option, (ResultSetHandler<T>)beanHandler);
    }

    @Override
    public <T> DWPaginationQueryBeanResult<T> selectWithPage(Class<T> clazz, DWPagableQueryInfo pagableQueryInfo) {
        return this.selectWithPage(clazz, pagableQueryInfo, null);
    }

    @Override
    public <T> DWPaginationQueryBeanResult<T> selectWithPage(Class<T> clazz, DWPagableQueryInfo pagableQueryInfo, DWDataSetOperationOption option) {
        int totalCount = this.selectTotalCount(pagableQueryInfo, null, option);
        BeanListHandler beanListHandler = new BeanListHandler(clazz, this.getRowProcessor());
        List data = (List)this.selectWithPage(pagableQueryInfo, null, option, (ResultSetHandler<T>)beanListHandler);
        DWPaginationQueryBeanResult result = new DWPaginationQueryBeanResult(pagableQueryInfo.getPageSize(), totalCount);
        result.setCurrentPage(pagableQueryInfo.getPageNumber(), data);
        return result;
    }

    private <T> T select(DWQueryInfo queryInfo, String sql, DWDataSetOperationOption option, ResultSetHandler<T> resultSetHandler) {
        DWSqlInfo sqlInfo = this.getDialect().parse(queryInfo, sql, option);
        String statement = sqlInfo.getSql();
        Object[] params = sqlInfo.getParameters();
        this.logSqlExecutingInfo(option, sqlInfo);
        try {
            QueryRunner queryRunner = this.getQueryRunner(option);
            return (T)queryRunner.query(statement, resultSetHandler, params);
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
    }

    private int selectTotalCount(DWPagableQueryInfo queryInfo, String sql, DWDataSetOperationOption option) {
        int totalCount = 0;
        List countResult = new ArrayList();
        DWSqlInfo countSqlInfo = this.getDialect().parseCount(queryInfo, sql, option);
        this.logSqlExecutingInfo(option, countSqlInfo);
        QueryRunner queryRunner = this.getQueryRunner(option);
        try {
            countResult = (List)queryRunner.query(countSqlInfo.getSql(), (ResultSetHandler)new MapListHandler(), countSqlInfo.getParameters());
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        if (null != countResult && null != countResult.get(0)) {
            Map countRow = (Map)countResult.get(0);
            Map.Entry countCell = countRow.entrySet().iterator().next();
            totalCount = Integer.parseInt(countCell.getValue().toString());
        }
        return totalCount;
    }

    private <T> T selectWithPage(DWPagableQueryInfo queryInfo, String sql, DWDataSetOperationOption option, ResultSetHandler<T> resultSetHandler) {
        DWSqlInfo sqlInfo = this.getDialect().parse(queryInfo, sql, option);
        String statement = sqlInfo.getSql();
        Object[] params = sqlInfo.getParameters();
        this.logSqlExecutingInfo(option, sqlInfo);
        try {
            QueryRunner queryRunner = this.getQueryRunner(option);
            return (T)queryRunner.query(statement, resultSetHandler, params);
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
    }

    private RowProcessor getRowProcessor() {
        if (this.mapUnderscoreToCamelCase) {
            return new BasicRowProcessor((BeanProcessor)new GenerousBeanProcessor());
        }
        return new BasicRowProcessor(new BeanProcessor());
    }

    @Override
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo) {
        String sql = null;
        return this.selectWithPage(pagableQueryInfo, sql);
    }

    @Override
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo, DWDataSetOperationOption option) {
        return this.selectWithPage(pagableQueryInfo, null, option);
    }

    private void logStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String stackTrace = stringWriter.toString();
        log.error((Object)stackTrace);
    }

    private void operateSqlLogCollector(String sql, Object ... params) {
        Map logRecordMap = DWServiceContext.getContext().getOperateLog();
        if (MapUtils.isNotEmpty((Map)logRecordMap) && ((Boolean)logRecordMap.get("isLogRecord")).booleanValue()) {
            HashMap<String, Object> currentSqlMap = new HashMap<String, Object>();
            currentSqlMap.put("statement", sql);
            currentSqlMap.put("parameters", Arrays.asList(params));
            HashMap<Integer, HashMap<Integer, HashMap<String, Object>>> logRecordSqlMap = (HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>)logRecordMap.get("sqlMap");
            if (MapUtils.isNotEmpty((Map)logRecordSqlMap)) {
                logRecordSqlMap.put(logRecordSqlMap.size() + 1, currentSqlMap);
            } else {
                logRecordSqlMap = new HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>();
                logRecordSqlMap.put(1, currentSqlMap);
                logRecordMap.put("sqlMap", logRecordSqlMap);
            }
        }
    }

    private class CascadeDeletingInstruction {
        private String primaryTableName;
        private DWSQLExecutionResult resultInfo;
        private DWDataSetOperationOption option;
        private List<DWCascadeDeletingInfo> deleteList;
        private Collection<DWRdbmsRelationshipAttribute> relations = null;

        private CascadeDeletingInstruction(String primaryTableName, DWDataSetOperationOption option, DWSQLExecutionResult resultInfo) {
            this.primaryTableName = primaryTableName;
            this.option = option;
            this.resultInfo = resultInfo;
            this.parse();
        }

        private void parse() {
            List<DWCascadeDeletingInfo> allSetting = this.option.getCascadingDeletingList();
            this.deleteList = allSetting.stream().filter(item -> this.primaryTableName.equals(item.getPrimary())).collect(Collectors.toList());
            if (this.deleteList.size() > 0) {
                DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)this.primaryTableName, DWRdbmsMetadata.class);
                this.relations = metadata.getAttributes(DWRdbmsRelationshipAttribute.class);
            }
        }

        private boolean hasReferenceCascadeSetting() {
            return this.deleteList.size() > 0;
        }

        private List<DWCascadeDeletingInfo> getCascadeDeletingList() {
            return this.deleteList;
        }

        private DWRdbmsRelationshipAttribute getMappingAttribute(DWCascadeDeletingInfo cascadTarget) {
            if (this.relations == null) {
                throw new DWDataException("13017", String.format("This table(%s) has no any cascade deleting setting!", this.primaryTableName));
            }
            String referenceName = cascadTarget.getReference();
            DWRdbmsRelationshipAttribute targetAttribute = this.relations.stream().filter(attr -> attr.getDetailTableName().equals(referenceName)).findFirst().get();
            if (targetAttribute == null) {
                throw new DWDataException("13018", String.format("cascade Query reference(%s) is not found in metadata", referenceName));
            }
            return targetAttribute;
        }
    }
}

