/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.DWDataException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DWSQLManagementFieldFilter
implements IDWSQLFilter {
    private static boolean mgmtFieldEnabled = DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().isMgmtFieldEnabled();
    public static String OPTION_MANAGEMENT_FIELD_ENABLED = "mgmtFieldEnabled";
    public static String OPTION_MANAGEMENT_FIELD_IGNORE_CUSTOM_VALUE = "mgmtFieldIgnoreCustomValue";
    public static String OPTION_MANAGEMENT_FIELD_ALIAS_NAME = "mgmtFieldAliasName";
    public static String PROPERTY_KEY_MGMT_FIELD_RESOLVER = "mgmtFieldResolver";
    public static String TAG_MGMT_FIELD_INSERT_COLUMNS = "${mgmtFieldInsertColumns}";
    public static String TAG_MGMT_FIELD_INSERT_PARAMS = "${mgmtFieldInsertParams}";
    public static String TAG_MGMT_FIELD_UPDATE_COLUMNS = "${mgmtFieldUpdateColumns}";
    public static String TAG_DISABLE_MGMT_FIELDS = "-${mgmtField}";
    private IDWManagementFieldResolver mgmtFieldResolver;
    private static boolean ignoreCustomValue = DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().isMgmtFieldIgnoreCustomValue();

    public DWSQLManagementFieldFilter(IDWManagementFieldResolver mgmtFieldResolver) {
        if (mgmtFieldResolver == null) {
            throw new IllegalArgumentException("mgmtFieldResolver is null!");
        }
        this.mgmtFieldResolver = mgmtFieldResolver;
    }

    public static boolean isEnabled() {
        return mgmtFieldEnabled;
    }

    public static boolean isIgnoreCustomValue() {
        return ignoreCustomValue;
    }

    public static void disableInOptions(IDWSQLOptions options) {
        DWSQLManagementFieldFilter.setEnabledInOptions(options, false);
    }

    public static void setEnabledInOptions(IDWSQLOptions options, boolean enabled) {
        options.set(OPTION_MANAGEMENT_FIELD_ENABLED, enabled);
    }

    public static void setIgnoreCustomValueInOptions(IDWSQLOptions options, boolean ignored) {
        options.set(OPTION_MANAGEMENT_FIELD_IGNORE_CUSTOM_VALUE, ignored);
    }

    public static boolean isEnabled(IDWSQLOptions options) {
        if (options == null) {
            return mgmtFieldEnabled;
        }
        boolean enabled = options.get(OPTION_MANAGEMENT_FIELD_ENABLED, DWSQLManagementFieldFilter.isEnabled());
        return enabled;
    }

    public static void setManagementFieldAliasName(IDWSQLOptions options, String aliasName) {
        options.set(OPTION_MANAGEMENT_FIELD_ALIAS_NAME, aliasName);
    }

    public static boolean isIgnoreCustomValue(IDWSQLOptions options) {
        if (options == null) {
            return ignoreCustomValue;
        }
        boolean ignored = options.get(OPTION_MANAGEMENT_FIELD_IGNORE_CUSTOM_VALUE, DWSQLManagementFieldFilter.isIgnoreCustomValue());
        return ignored;
    }

    public static String getManagementFieldAliasName(IDWSQLOptions options) {
        if (options == null) {
            return "";
        }
        String managementFieldAliasName = options.get(OPTION_MANAGEMENT_FIELD_ALIAS_NAME, "");
        return managementFieldAliasName;
    }

    @Override
    public void doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        String sql = sqlInfo.getSql();
        List<Object> parameters = sqlInfo.getParametersAsList();
        if (DWSQLManagementFieldFilter.isEnabled(options)) {
            CharSequence[] insertFields = this.mgmtFieldResolver.getInsertFields();
            String[] updateFields = this.mgmtFieldResolver.getUpdateFields();
            boolean insertFieldCountZero = insertFields.length == 0;
            boolean hasTag = false;
            if (sql.contains(TAG_DISABLE_MGMT_FIELDS)) {
                hasTag = true;
                sql = sql.replaceAll(Pattern.quote(TAG_DISABLE_MGMT_FIELDS), "");
            }
            if (sql.contains(TAG_MGMT_FIELD_INSERT_COLUMNS)) {
                hasTag = true;
                String replacedColumnString = (insertFieldCountZero ? "" : ", ") + String.join((CharSequence)", ", insertFields);
                sql = sql.replaceAll(Pattern.quote(TAG_MGMT_FIELD_INSERT_COLUMNS), replacedColumnString);
            }
            if (sql.contains(TAG_MGMT_FIELD_INSERT_PARAMS)) {
                hasTag = true;
                String replacedParameterString = (insertFieldCountZero ? "" : ", ") + String.join((CharSequence)", ", Collections.nCopies(insertFields.length, "?"));
                sql = sql.replaceAll(Pattern.quote(TAG_MGMT_FIELD_INSERT_PARAMS), replacedParameterString);
                parameters.addAll(this.mgmtFieldResolver.getInsertFieldValues());
            }
            if (sql.contains(TAG_MGMT_FIELD_UPDATE_COLUMNS)) {
                hasTag = true;
                ArrayList<String> columnValueSetList = new ArrayList<String>();
                String updateFieldAliasName = DWSQLManagementFieldFilter.getManagementFieldAliasName(options);
                for (String updateField : updateFields) {
                    Object value = this.mgmtFieldResolver.getFieldValue(updateField);
                    String columnValueSet = !"".equals(updateFieldAliasName) ? updateFieldAliasName + "." + updateField + "=" : updateField + "=";
                    columnValueSet = columnValueSet + (value == null ? "null" : "'" + value.toString() + "'");
                    columnValueSetList.add(columnValueSet);
                }
                String replacedParameterString = (columnValueSetList.size() == 0 ? "" : ", ") + String.join((CharSequence)", ", columnValueSetList);
                replacedParameterString = Matcher.quoteReplacement(replacedParameterString);
                sql = sql.replaceAll(Pattern.quote(TAG_MGMT_FIELD_UPDATE_COLUMNS), replacedParameterString);
            }
            if (!hasTag) {
                throw new DWDataException("13014", String.format("[DWSQLManagementFieldFilter] related management field tag(%s/%s/%s) is missing in sql.", TAG_MGMT_FIELD_INSERT_COLUMNS, TAG_MGMT_FIELD_INSERT_PARAMS, TAG_MGMT_FIELD_UPDATE_COLUMNS));
            }
        }
        sql = sql.replaceAll(Pattern.quote(TAG_DISABLE_MGMT_FIELDS), "");
        sqlInfo.setSqlAndParameters(sql, parameters);
    }

    @Override
    public void doFilter(DWQueryInfo queryInfo, IDWSQLOptions options) {
    }

    @Override
    public void doFilter(DWDataRow dataRow, IDWSQLOptions options) {
        if (!DWSQLManagementFieldFilter.isEnabled(options)) {
            return;
        }
        String[] targetFields = null;
        String[] oppsiteFields = null;
        if (dataRow.isNew()) {
            targetFields = this.mgmtFieldResolver.getInsertFields();
            if (!DWSQLManagementFieldFilter.isIgnoreCustomValue(options)) {
                oppsiteFields = this.mgmtFieldResolver.getUpdateFields();
            }
        } else if (dataRow.isUpdate()) {
            targetFields = this.mgmtFieldResolver.getUpdateFields();
            if (!DWSQLManagementFieldFilter.isIgnoreCustomValue(options)) {
                oppsiteFields = this.mgmtFieldResolver.getInsertFields();
            }
        }
        if (oppsiteFields != null) {
            Map<String, Object> data = dataRow.getData();
            String[] stringArray = oppsiteFields;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String notAllowedFieldName = stringArray[i];
                data.remove(notAllowedFieldName);
            }
        }
        if (targetFields != null) {
            for (String fieldName : targetFields) {
                dataRow.set(fieldName, this.mgmtFieldResolver.getFieldValue(fieldName));
            }
        }
    }
}

