/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data.validation;

import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.data.validation.DWVDQueryInfo;
import com.digiwin.app.data.validation.DWVDQueryInfos;
import com.digiwin.app.validation.DWConstraintViolationException;
import java.util.Arrays;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;

public class DWQueryInfosValidator
implements ConstraintValidator<DWVDQueryInfos, DWQueryInfo> {
    private DWVDQueryInfo[] vdQueryInfos;

    public void initialize(DWVDQueryInfos constraintAnnotation) {
        DWVDQueryInfo[] vdQueryInfos;
        for (DWVDQueryInfo vdQueryInfo : vdQueryInfos = constraintAnnotation.value()) {
            DWQueryInfosValidator.validateParameters(vdQueryInfo);
        }
        this.vdQueryInfos = vdQueryInfos;
    }

    public boolean isValid(DWQueryInfo value, ConstraintValidatorContext context) {
        return DWQueryInfosValidator.isValid(this.vdQueryInfos, value, context);
    }

    static void validateParameters(DWVDQueryInfo queryInfo) {
    }

    static boolean isValid(DWVDQueryInfo[] vdQueryInfos, DWQueryInfo value, ConstraintValidatorContext context) {
        DWPagableQueryInfo pageableInfo;
        DWVDQueryInfo mappingVDQueryInfo;
        String inputTableName = value.getTableName();
        if (vdQueryInfos.length == 1 && (vdQueryInfos[0].name() == null || vdQueryInfos[0].name().length() == 0)) {
            mappingVDQueryInfo = vdQueryInfos[0];
        } else {
            mappingVDQueryInfo = Arrays.stream(vdQueryInfos).filter(vdQueryInfo -> inputTableName.equalsIgnoreCase(vdQueryInfo.name())).findFirst().orElse(null);
            if (mappingVDQueryInfo == null) {
                String errorTemplate = "{" + DWConstraintViolationException.ERROR_CODE + "_3}";
                HibernateConstraintValidatorContext hibernateContext = (HibernateConstraintValidatorContext)context.unwrap(HibernateConstraintValidatorContext.class);
                hibernateContext.addMessageParameter("illegalTables", (Object)inputTableName).buildConstraintViolationWithTemplate(errorTemplate).addConstraintViolation().disableDefaultConstraintViolation();
                return false;
            }
        }
        if (mappingVDQueryInfo.maxPageSize() > -1 && value instanceof DWPagableQueryInfo && (pageableInfo = (DWPagableQueryInfo)value).getPageSize() > mappingVDQueryInfo.maxPageSize()) {
            String errorTemplate = "{" + DWConstraintViolationException.ERROR_CODE + "_4}";
            HibernateConstraintValidatorContext hibernateContext = (HibernateConstraintValidatorContext)context.unwrap(HibernateConstraintValidatorContext.class);
            hibernateContext.addMessageParameter("illegalPageSize", (Object)mappingVDQueryInfo.maxPageSize()).buildConstraintViolationWithTemplate(errorTemplate).addConstraintViolation().disableDefaultConstraintViolation();
            return false;
        }
        return true;
    }
}

