/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.basic;

import com.digiwin.app.dao.DWBatchDataRowSqlInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.basic.DWBasicDao;
import com.digiwin.app.dao.basic.DWDataSetOperationOptionBuilder;
import com.digiwin.app.dao.dialect.DWMySQLDialect;
import com.digiwin.app.dao.dialect.DWSQLDialect;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.app.data.DWSQLOptionsBuilder;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.ExecuteException;
import com.digiwin.app.service.DWServiceContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWBasicDaoImpl
implements DWBasicDao {
    private static Log log = LogFactory.getLog(DWBasicDaoImpl.class);
    private QueryRunner queryRunner;
    private DWSQLDialect dialect;
    private DWDaoProperties properties;

    public DWBasicDaoImpl(QueryRunner queryRunner) {
        this.queryRunner = queryRunner;
    }

    @Override
    public QueryRunner getQueryRunner() {
        return this.getQueryRunner(null);
    }

    @Override
    public QueryRunner getQueryRunner(IDWSQLOptions option) {
        return this.queryRunner;
    }

    public void setDialect(DWSQLDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect is null!");
        }
        this.dialect = dialect;
    }

    @Override
    public DWSQLDialect getDialect() {
        if (this.dialect == null) {
            this.dialect = new DWMySQLDialect();
        }
        return this.dialect;
    }

    public void setProperties(DWDaoProperties properties) {
        this.properties = properties;
    }

    @Override
    public DWDaoProperties getProperties() {
        return this.properties;
    }

    @Override
    public List<Map<String, Object>> select(String statement, Object ... params) {
        return this.select(null, statement, params);
    }

    @Override
    public List<Map<String, Object>> select(IDWSQLOptions options, String statement, Object ... params) {
        if (options == null) {
            options = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        options = DWDataSetOperationOptionBuilder.disabledManagementFields(options);
        DWSqlInfo sqlInfo = this.getDialect().parse(options, statement, params);
        return (List)this.innerQuery(sqlInfo, (ResultSetHandler)new MapListHandler(), options);
    }

    @Override
    public int update(String statement, Object ... params) {
        return this.update(null, statement, params);
    }

    @Override
    public int update(IDWSQLOptions options, String statement, Object ... params) {
        if (options == null) {
            options = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        DWSqlInfo sqlInfo = this.getDialect().parse(options, statement, params);
        return this.innerUpdate(sqlInfo, options);
    }

    protected <T> T innerQuery(DWSqlInfo sqlInfo, ResultSetHandler<T> resultSetHandler, IDWSQLOptions options) {
        String statement = sqlInfo.getSql();
        Object[] params = sqlInfo.getParameters();
        this.logSqlExecutingInfo(options, sqlInfo);
        try {
            QueryRunner queryRunner = this.getQueryRunner(options);
            return (T)queryRunner.query(statement, resultSetHandler, params);
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
    }

    protected int innerUpdate(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        int result = 0;
        String statement = sqlInfo.getSql();
        Object[] params = sqlInfo.getParameters();
        this.logSqlExecutingInfo(options, sqlInfo);
        try {
            QueryRunner queryRunner = this.getQueryRunner(options);
            result = queryRunner.update(statement, params);
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        return result;
    }

    protected int[] innerBatch(DWBatchDataRowSqlInfo batchSqlInfo, IDWSQLOptions options) {
        int[] batchResult = new int[]{};
        this.logSqlExecutingInfo(options, batchSqlInfo);
        try {
            QueryRunner queryRunner = this.getQueryRunner(options);
            batchResult = queryRunner.batch(batchSqlInfo.getSql(), batchSqlInfo.getBatchParameters());
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        return batchResult;
    }

    protected List<Map<String, Object>> innerInsert(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        List result;
        this.logSqlExecutingInfo(options, sqlInfo);
        try {
            QueryRunner queryRunner = this.getQueryRunner(options);
            result = (List)queryRunner.insert(sqlInfo.getSql(), (ResultSetHandler)new MapListHandler(), sqlInfo.getParameters());
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        return result;
    }

    protected List<Map<String, Object>> innerInsertBatch(DWBatchDataRowSqlInfo batchSqlInfo, IDWSQLOptions options) {
        List result;
        this.logSqlExecutingInfo(options, batchSqlInfo);
        try {
            QueryRunner queryRunner = this.getQueryRunner(options);
            result = (List)queryRunner.insertBatch(batchSqlInfo.getSql(), (ResultSetHandler)new MapListHandler(), batchSqlInfo.getBatchParameters());
        }
        catch (SQLException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        return result;
    }

    protected void logStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String stackTrace = stringWriter.toString();
        log.error((Object)stackTrace);
    }

    protected void logSqlExecutingInfo(IDWSQLOptions option, DWSqlInfo sqlInfo) {
        StringBuilder parameterInfo = new StringBuilder();
        Object[] parameters = sqlInfo.getParameters();
        int seq = 0;
        int count = parameters.length;
        for (Object p : parameters) {
            parameterInfo.append(p);
            if (p == null) {
                parameterInfo.append("(Unknown)");
            } else {
                parameterInfo.append("(").append(p.getClass().getSimpleName()).append(")");
            }
            if (++seq == count) continue;
            parameterInfo.append(", ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[SQL.statement]" + sqlInfo.getSql()));
            log.debug((Object)("[SQL.params]" + parameterInfo.toString()));
        }
        this.operateSqlLogCollector(option, sqlInfo.getSql(), parameters);
    }

    protected void logSqlExecutingInfo(IDWSQLOptions option, DWBatchDataRowSqlInfo batchSqlInfo) {
        StringBuilder parameterInfo = new StringBuilder();
        List<List<Object>> batchRowParameters = batchSqlInfo.getBatchParametersAsList();
        ArrayList<Object> totalParameters = new ArrayList<Object>();
        int rowNo = 1;
        for (List<Object> batchRowParameter : batchRowParameters) {
            int seq = 0;
            int count = batchRowParameter.size();
            parameterInfo.append("[row=" + rowNo + "]");
            for (Object p : batchRowParameter) {
                totalParameters.add(p);
                parameterInfo.append(p);
                if (p == null) {
                    parameterInfo.append("(Unknown)");
                } else {
                    parameterInfo.append("(").append(p.getClass().getSimpleName()).append(")");
                }
                if (++seq == count) continue;
                parameterInfo.append(", ");
            }
            ++rowNo;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[SQL.statement]" + batchSqlInfo.getSql()));
            log.debug((Object)("[SQL.params]" + parameterInfo.toString()));
        }
        this.operateSqlLogCollector(option, batchSqlInfo.getSql(), totalParameters.toArray());
    }

    private void operateSqlLogCollector(IDWSQLOptions dwSqlOption, String sql, Object ... params) {
        boolean mergedLogBasicEnabled = false;
        boolean mergedLogSqlEnabled = false;
        Map operateLogMap = DWServiceContext.getContext().getOperateLog();
        if (MapUtils.isNotEmpty((Map)operateLogMap)) {
            mergedLogBasicEnabled = (Boolean)operateLogMap.get("isLogRecord");
            mergedLogSqlEnabled = (Boolean)operateLogMap.get("isLogSqlRecord");
        }
        if (mergedLogBasicEnabled && mergedLogSqlEnabled) {
            boolean dataSetOptionLogSqlEnabled = false;
            boolean daoOptionValueOfOperateLogEnabled = true;
            dataSetOptionLogSqlEnabled = dwSqlOption != null ? (daoOptionValueOfOperateLogEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)dwSqlOption.get(DWSQLOptionsBuilder.OPTION_LOG_OPERATION_ENABLED)), (boolean)true)) : true;
            if (dataSetOptionLogSqlEnabled) {
                HashMap<String, Object> currentSqlMap = new HashMap<String, Object>();
                currentSqlMap.put("statement", sql);
                currentSqlMap.put("parameters", Arrays.asList(params));
                HashMap<Integer, HashMap<Integer, HashMap<String, Object>>> logRecordSqlMap = (HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>)operateLogMap.get("sqlMap");
                if (MapUtils.isNotEmpty((Map)logRecordSqlMap)) {
                    logRecordSqlMap.put(logRecordSqlMap.size() + 1, currentSqlMap);
                } else {
                    logRecordSqlMap = new HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>();
                    logRecordSqlMap.put(1, currentSqlMap);
                    operateLogMap.put("sqlMap", logRecordSqlMap);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("dataSetOptionLogSqlEnabled=%b (mergedLogBasicEnabled=%b, mergedLogSqlEnabled=%b, daoOptionValueOfOperateLogEnabled=%s !)", dataSetOptionLogSqlEnabled, mergedLogBasicEnabled, mergedLogSqlEnabled, daoOptionValueOfOperateLogEnabled));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("mergedLogBasicEnabled=%b mergedLogSqlEnabled=%b ", mergedLogBasicEnabled, mergedLogSqlEnabled));
        }
    }
}

