/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.IDWSQLOptions;
import java.util.Collections;
import java.util.List;

public class DWSQLFilterChain
implements IDWSQLFilter {
    private List<IDWSQLFilter> filters;

    public DWSQLFilterChain(List<IDWSQLFilter> filters) {
        if (filters == null) {
            filters = Collections.emptyList();
        }
        this.filters = filters;
    }

    @Override
    public void doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        for (IDWSQLFilter filter : this.filters) {
            filter.doFilter(sqlInfo, options);
        }
    }

    @Override
    public void doFilter(DWQueryInfo queryInfo, IDWSQLOptions options) {
        for (IDWSQLFilter filter : this.filters) {
            filter.doFilter(queryInfo, options);
        }
    }

    @Override
    public void doFilter(DWDataRow dataRow, IDWSQLOptions options) {
        for (IDWSQLFilter filter : this.filters) {
            filter.doFilter(dataRow, options);
        }
    }

    @Override
    public void doFilterOthers(Object otherObject, IDWSQLOptions options) {
        for (IDWSQLFilter filter : this.filters) {
            filter.doFilterOthers(otherObject, options);
        }
    }
}

