/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.datasource;

import com.digiwin.app.dao.DWDaoImpl;
import com.digiwin.app.dao.datasource.DWAbstractTenantDataSource;
import com.digiwin.app.dao.datasource.DWDataSourceConstants;
import com.digiwin.app.dao.datasource.utils.DWMultipleDataSourcePropertiesUtil;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class DWTenantDataSource
extends DWAbstractTenantDataSource {
    private static Log _log = LogFactory.getLog(DWTenantDataSource.class);
    private static String _CLASSTAG = "[DWTenantDataSource] ";
    private String tableDsConfig = "dw_datasource_config";
    private String tableDsTenant = "dw_datasource_tenant";
    private String columnDsName = "dsname";
    private String columnDsUrl = "dsurl";
    private String columnDsUsername = "username";
    private String columnDsPassword = "password";
    private String columnDsClassName = "dsclassname";
    private String columnDsConnectionProperties = "connectionproperties";
    private String columnTenantSid = DWDataSourceConstants.COLUMN_TENANTSID;
    private String columnTenantDsName = "dsname";
    private String sourceBeanName = "dw-dao";
    private String datasourceConfigSql;
    private String datasourceTenantSql;

    public DWTenantDataSource() {
        this.initialize();
    }

    public DWTenantDataSource(String sourceBeanName) {
        this.sourceBeanName = sourceBeanName;
        this.initialize();
    }

    @Override
    public void initialize() {
        String currentModuleName = DWModuleClassLoader.getCurrentModuleName();
        this.initialize(currentModuleName);
    }

    @Override
    public void initialize(String moduleName) {
        boolean isConfigData = false;
        boolean isTenantData = false;
        try {
            DWDaoImpl dwdao = (DWDaoImpl)SpringContextUtils.getBean((String)this.sourceBeanName);
            if (dwdao != null) {
                DWDataSetOperationOption option = new DWDataSetOperationOption();
                option.setTenantEnabled(false);
                this.initSql(moduleName);
                List<Map<String, Object>> dbList = dwdao.select((IDWSQLOptions)option, this.datasourceConfigSql, new Object[0]);
                if (dbList != null && dbList.size() > 0) {
                    isConfigData = true;
                    HashMap<Object, QueryRunner> tempDataSources = new HashMap<Object, QueryRunner>();
                    for (Map<String, Object> row : dbList) {
                        BasicDataSource basicDataSource = new BasicDataSource();
                        basicDataSource.setDriverClassName((String)row.get(this.columnDsClassName));
                        basicDataSource.setUrl((String)row.get(this.columnDsUrl));
                        basicDataSource.setUsername((String)row.get(this.columnDsUsername));
                        basicDataSource.setPassword((String)row.get(this.columnDsPassword));
                        String connectionOptions = (String)row.get(this.columnDsConnectionProperties);
                        if (StringUtils.isNotBlank((CharSequence)connectionOptions)) {
                            this.connConfigHandle(basicDataSource, connectionOptions);
                        }
                        TransactionAwareDataSourceProxy transactionAwareDataSourceProxy = new TransactionAwareDataSourceProxy((DataSource)basicDataSource);
                        QueryRunner queryRunner = new QueryRunner((DataSource)transactionAwareDataSourceProxy);
                        tempDataSources.put(row.get(this.columnDsName), queryRunner);
                        _log.debug((Object)(_CLASSTAG + " found dsname:" + row.get(this.columnDsName)));
                    }
                    this.dataSources = tempDataSources;
                } else {
                    _log.debug((Object)(_CLASSTAG + "no data in datasourceConfigSql"));
                }
                if (isConfigData) {
                    List<Map<String, Object>> dbTenantList = dwdao.select((IDWSQLOptions)option, this.datasourceTenantSql, new Object[0]);
                    Map<Object, Object> tempDataSourceTenants = this.getTenantDataSourceNameRelation(dbTenantList);
                    if (tempDataSourceTenants != null && tempDataSourceTenants.size() > 0) {
                        isTenantData = true;
                        this.dataSourceTenants = tempDataSourceTenants;
                    }
                } else {
                    _log.debug((Object)(_CLASSTAG + "no data in datasourceTenantSql"));
                }
            } else {
                _log.warn((Object)(_CLASSTAG + this.sourceBeanName + " is null, ignore tenant multiple datasource"));
            }
            if (isConfigData && isTenantData) {
                this.multipleDatasouce = true;
            }
        }
        catch (Exception e) {
            _log.error((Object)(_CLASSTAG + "initialize error"), (Throwable)e);
        }
    }

    public void setDatasourceConfigSql(String datasourceConfigSql) {
        this.datasourceConfigSql = datasourceConfigSql;
    }

    public String getDatasourceConfigSql() {
        return this.datasourceConfigSql;
    }

    public String getDatasourceTenantSql() {
        return this.datasourceTenantSql;
    }

    public void setDatasourceTenantSql(String datasourceTenantSql) {
        this.datasourceTenantSql = datasourceTenantSql;
    }

    private void initSql(String moduleName) {
        String tempDatasourceConfigSql = DWMultipleDataSourcePropertiesUtil.getSqlByParamKey("daoMultipleDataSourceConfigSql", moduleName);
        String tempDatasourceTenantSql = DWMultipleDataSourcePropertiesUtil.getSqlByParamKey("daoMultipleDataSourceTenantSql", moduleName);
        if (StringUtils.isNotBlank((CharSequence)tempDatasourceConfigSql)) {
            this.setDatasourceConfigSql(tempDatasourceConfigSql);
        } else {
            this.datasourceConfigSql = "SELECT " + this.columnDsName + "," + this.columnDsUrl + "," + this.columnDsClassName + "," + this.columnDsUsername + "," + this.columnDsPassword + "," + this.columnDsConnectionProperties + " FROM " + this.tableDsConfig;
        }
        if (StringUtils.isNotBlank((CharSequence)tempDatasourceTenantSql)) {
            this.setDatasourceTenantSql(tempDatasourceTenantSql);
        } else {
            this.datasourceTenantSql = "SELECT " + this.columnTenantSid + "," + this.columnTenantDsName + " FROM " + this.tableDsTenant;
        }
    }

    public Map<Object, Object> getTenantDataSourceNameRelation(List<Map<String, Object>> dbTenantList) {
        HashMap<Object, Object> retVal = new HashMap<Object, Object>();
        if (dbTenantList != null && dbTenantList.size() > 0) {
            for (Map<String, Object> row : dbTenantList) {
                retVal.put(row.get(this.columnTenantSid), row.get(this.columnTenantDsName));
                _log.debug((Object)(_CLASSTAG + " found tenant-dsname(" + row.get(this.columnTenantSid) + "," + row.get(this.columnTenantDsName) + ")"));
            }
        }
        return retVal;
    }
}

