/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryExists;
import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryOrderby;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.sql.DWFieldRegexUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DWSQLInjectionCheckFilter
implements IDWSQLFilter {
    public static String OPTION_CHECK_SQL_INJECTION_ENABLED = "checkSqlInjectionEnabled";
    private boolean isCheckSqlInjection;

    public void setCheckSqlInjection(boolean checkSqlInjection) {
        this.isCheckSqlInjection = checkSqlInjection;
    }

    @Override
    public void doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options) {
    }

    @Override
    public void doFilter(DWQueryInfo queryInfo, IDWSQLOptions options) {
        if (!this.isEnabled(options)) {
            return;
        }
        List<Object> checkObjects = this.packageCheckObject(queryInfo);
        SqlInjectionVerification verification = new SqlInjectionVerification(checkObjects);
        verification.checkSqlInjection();
    }

    @Override
    public void doFilter(DWDataRow dataRow, IDWSQLOptions options) {
    }

    public List<Object> packageCheckObject(DWQueryInfo queryInfo) {
        DWQueryCondition condition;
        List<DWQueryOrderby> orderByList;
        ArrayList<Object> checkObjects = new ArrayList<Object>();
        List<Object> fields = queryInfo.getSelectObjects();
        if (Objects.nonNull(fields)) {
            checkObjects.addAll(fields);
        }
        if (Objects.nonNull(orderByList = queryInfo.getOrderfields())) {
            checkObjects.addAll(orderByList);
        }
        if (Objects.nonNull(condition = queryInfo.getCondition())) {
            checkObjects.add(condition);
        }
        return checkObjects;
    }

    private boolean isEnabled(IDWSQLOptions options) {
        if (options == null) {
            return this.isCheckSqlInjection;
        }
        return options.get(OPTION_CHECK_SQL_INJECTION_ENABLED, this.isCheckSqlInjection);
    }

    public static class SqlInjectionVerification {
        private List<Object> checkObj;

        public SqlInjectionVerification(List<Object> checkObj) {
            this.checkObj = checkObj;
        }

        private <T> void checkList(List<T> list) {
            if (Objects.nonNull(list)) {
                for (T t : list) {
                    this.checkSqlInjection(t);
                }
            }
        }

        public void checkSqlInjection() {
            this.checkList(this.checkObj);
        }

        public void checkSqlInjection(Object obj) {
            if (obj instanceof String) {
                this.checkSqlInjection((String)obj);
            } else if (obj instanceof DWQueryInfo) {
                this.checkSqlInjection((DWQueryInfo)obj);
            } else if (obj instanceof DWQueryOrderby) {
                this.checkSqlInjection((DWQueryOrderby)obj);
            } else if (obj instanceof DWQueryCondition) {
                this.checkSqlInjection((DWQueryCondition)obj);
            } else if (obj instanceof DWQueryField) {
                this.checkSqlInjection((DWQueryField)obj);
            } else if (obj instanceof DWQueryExists) {
                // empty if block
            }
        }

        private void checkSqlInjection(String str) {
            if (StringUtils.isEmpty((CharSequence)str)) {
                return;
            }
            if (DWFieldRegexUtils.isSQLInjection(str)) {
                throw new RuntimeException(String.format("SQL Injection:[%s]", str));
            }
        }

        private void checkSqlInjection(DWQueryInfo queryInfo) {
            this.checkList(queryInfo.getSelectObjects());
        }

        private void checkSqlInjection(DWQueryOrderby dwQueryOrderby) {
            String orderByStr = dwQueryOrderby.getName() + " " + dwQueryOrderby.getOrderby();
            this.checkSqlInjection(orderByStr);
        }

        private void checkSqlInjection(DWQueryCondition queryCondition) {
            this.checkList(queryCondition.getItems());
        }

        private void checkSqlInjection(DWQueryField queryField) {
            this.checkSqlInjection(queryField.getName());
        }
    }
}

