/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data.exceptions;

import com.digiwin.app.dao.properties.DWDaoDataSetProperties;
import com.digiwin.app.dao.properties.DWDaoProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWDaoExceptionHandler {
    private static Log log = LogFactory.getLog(DWDaoExceptionHandler.class);

    public static SQLException handle(DWDaoProperties dwDaoProperties, SQLException sqlException) {
        try {
            DWDaoDataSetProperties dwDaoDataSetProperties = dwDaoProperties.getDataSetProperties();
            if (dwDaoDataSetProperties.isDwdaoExceptionSQLMask()) {
                String detailMessage = sqlException.getMessage();
                String tagQuery = "Query:";
                int queryStartIndex = detailMessage.indexOf(tagQuery);
                int parametersStartIndex = detailMessage.indexOf(" Parameters:");
                if (queryStartIndex != -1 && parametersStartIndex != -1) {
                    String resultPrefix = detailMessage.substring(0, queryStartIndex + tagQuery.length());
                    String resultPostfix = detailMessage.substring(parametersStartIndex, detailMessage.length());
                    String newDetailMessage = resultPrefix + "##sql-mask##" + resultPostfix;
                    Class<Throwable> throwableClassClass = Throwable.class;
                    Field detailMessageField = throwableClassClass.getDeclaredField("detailMessage");
                    detailMessageField.setAccessible(true);
                    detailMessageField.set(sqlException, newDetailMessage);
                }
            }
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.error((Object)stackTrace);
        }
        return sqlException;
    }
}

