/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.datasource;

import com.digiwin.app.dao.datasource.DWAbstractTenantDataSource;
import com.digiwin.app.dao.datasource.DWTenantDataSourceException;
import com.digiwin.app.dao.datasource.utils.DWMultipleDataSourcePropertiesUtil;
import com.digiwin.app.dao.datasource.utils.DWTenantDataSourceUtils;
import com.digiwin.app.module.DWModuleClassLoader;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.DWBasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.CollectionUtils;

public class DWTenantDataSourceByFile
extends DWAbstractTenantDataSource {
    private static Log log = LogFactory.getLog(DWTenantDataSourceByFile.class);
    private static String _CLASSTAG = "[DWTenantDataSourceByFile] ";
    private String columnDsName = "dsname";
    private String columnDsUrl = "dsurl";
    private String columnDsUsername = "username";
    private String columnDsPassword = "password";
    private String columnDsClassName = "dsclassname";
    private String columnDsConnectionProperties = "connectionproperties";
    private Map<Object, Object> dsTenantSidMap = Maps.newHashMap();

    public DWTenantDataSourceByFile() {
        this.initialize();
    }

    @Override
    public void initialize() {
        String currentModuleName = DWModuleClassLoader.getCurrentModuleName();
        this.initialize(currentModuleName);
    }

    @Override
    public void initialize(String moduleName) {
        boolean isConfigData = false;
        boolean isTenantData = false;
        Properties dataSourceConfig = DWMultipleDataSourcePropertiesUtil.getMultipleDataSourceProperties(moduleName);
        Map<String, DataSource> dataSourceMap = this.dynamicDataSources(dataSourceConfig);
        if (!CollectionUtils.isEmpty(dataSourceMap)) {
            isConfigData = true;
            HashMap tempDataSources = Maps.newHashMap();
            dataSourceMap.forEach((dsName, dataSource) -> {
                TransactionAwareDataSourceProxy transactionAwareDataSourceProxy = new TransactionAwareDataSourceProxy(dataSource);
                QueryRunner queryRunner = new QueryRunner((DataSource)transactionAwareDataSourceProxy);
                tempDataSources.put(dsName, queryRunner);
                log.debug((Object)(_CLASSTAG + " found dsname:" + dsName));
            });
            this.dataSources = tempDataSources;
        } else {
            log.debug((Object)(_CLASSTAG + "no data in datasourceConfig"));
        }
        if (isConfigData) {
            this.dataSourceTenants = this.dsTenantSidMap;
            if (this.dataSourceTenants != null && ((Map)this.dataSourceTenants).size() > 0) {
                isTenantData = true;
            } else {
                log.debug((Object)(_CLASSTAG + "no data in datasourceTenant"));
            }
        }
        if (isConfigData && isTenantData) {
            this.multipleDatasouce = true;
        }
    }

    public List<Map<String, Object>> getDataSource(Properties properties) {
        ArrayList<Map<String, Object>> dbList = new ArrayList<Map<String, Object>>();
        for (Object key : properties.keySet()) {
            String dsName = (String)key;
            String rawValue = properties.getProperty(dsName, null);
            String[] values = rawValue.split(",");
            HashMap<String, String> db = new HashMap<String, String>();
            db.put(this.columnDsName, (String)key);
            db.put(this.columnDsUrl, values[0]);
            db.put(this.columnDsUsername, values[1]);
            db.put(this.columnDsPassword, values[2]);
            db.put(this.columnDsClassName, values[3]);
            if (values.length > 4) {
                db.put(this.columnDsConnectionProperties, values[4]);
            } else {
                db.put(this.columnDsConnectionProperties, "");
            }
            dbList.add(db);
        }
        return dbList;
    }

    public Object getDataSourceTenant(Properties properties) {
        HashMap<BigInteger, String> dbList = new HashMap<BigInteger, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String tenantsid = (String)entry.getKey();
            String dsName = (String)entry.getValue();
            dbList.put(new BigInteger(tenantsid), dsName);
        }
        return dbList;
    }

    private Map<String, DataSource> dynamicDataSources(Properties properties) {
        HashMap dataSourceMap = Maps.newHashMap();
        String dsNames = properties.getProperty("dap.dwdao.tenant.dsnames");
        if (StringUtils.isBlank((CharSequence)dsNames)) {
            throw new DWTenantDataSourceException("Property 'dap.dwdao.tenant.dsnames' not configured.");
        }
        List dsNameList = Splitter.on((String)",").splitToList((CharSequence)dsNames);
        for (String dsName : dsNameList) {
            String dsTenantSidKey = String.format("dap.dwdao.%s.tenantsid", dsName);
            String dsTenantSid = properties.getProperty(dsTenantSidKey);
            if (StringUtils.isBlank((CharSequence)dsTenantSid)) {
                throw new DWTenantDataSourceException("Property '" + dsTenantSidKey + "' not configured.");
            }
            String dsTenantPrefix = String.format("dap.dwdao.%s.datasource", dsName);
            Map<String, Object> camelProperties = this.getAndConvertProperty(properties, dsTenantPrefix);
            Object driverClassName = camelProperties.get("driverClassName");
            Object url = camelProperties.get("url");
            Object username = camelProperties.get("username");
            Object password = camelProperties.get("password");
            super.validDataSourceBaseProperty(driverClassName, url, username, password);
            DataSource dataSource = this.buildDataSource(camelProperties);
            dataSourceMap.put(dsName, dataSource);
            this.makeDsTenantSidMap(dsTenantSid, dsName);
        }
        return dataSourceMap;
    }

    private DataSource buildDataSource(Map<String, Object> dsProperties) {
        Object dataSource = null;
        Object dataSourceTypeObj = dsProperties.remove("type");
        if (Objects.isNull(dataSourceTypeObj) || StringUtils.isBlank((CharSequence)dataSourceTypeObj.toString())) {
            dataSource = new DWBasicDataSource();
        } else {
            try {
                Class<?> dataSourceType = Class.forName(dataSourceTypeObj.toString());
                dataSource = (DataSource)dataSourceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new DWTenantDataSourceException("Failed to create DataSource['" + dataSourceTypeObj + "'] instance", e);
            }
        }
        this.setDataSourceProperties((DataSource)dataSource, dsProperties);
        return dataSource;
    }

    private void setDataSourceProperties(DataSource dataSource, Map<String, Object> properties) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl((Object)dataSource);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            Method setterMethod = super.findSetterMethod(dataSource, propertyName);
            if (ArrayUtils.isEmpty((Object[])setterMethod.getParameterTypes())) {
                throw new DWTenantDataSourceException("DataSource property '" + propertyName + "' setter method not found.");
            }
            Object fieldValue = super.convertPropertyValue(propertyValue, setterMethod.getParameterTypes()[0]);
            beanWrapper.setPropertyValue(propertyName, fieldValue);
        }
    }

    private Map<String, Object> getAndConvertProperty(Properties properties, String prefix) {
        HashMap dataSourceProperties = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String property = entry.getKey().toString();
            if (!property.startsWith(prefix)) continue;
            if ((property = StringUtils.substringAfterLast((String)property, (String)".")).contains("-")) {
                property = DWTenantDataSourceUtils.convertKebabToCamelCase(property);
            }
            dataSourceProperties.put(property, entry.getValue());
        }
        return dataSourceProperties;
    }

    private void makeDsTenantSidMap(String dsTenantSidStr, String dsName) {
        List dsTenantSidList = Splitter.on((String)",").splitToList((CharSequence)dsTenantSidStr);
        for (String dsTenantSidItem : dsTenantSidList) {
            this.dsTenantSidMap.put(new BigInteger(dsTenantSidItem), dsName);
        }
    }
}

