/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data.validation;

import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.validation.DWDataTablesValidator;
import com.digiwin.app.data.validation.DWVDTable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class DWDataTableValidator
implements ConstraintValidator<DWVDTable, DWDataSet> {
    private Map<String, Set<String>> allowedTables;

    public void initialize(DWVDTable constraintAnnotation) {
        DWVDTable[] tables = new DWVDTable[]{constraintAnnotation};
        DWDataTablesValidator.validateParameters(tables);
        this.allowedTables = new HashMap<String, Set<String>>();
        Set operations = Arrays.stream(constraintAnnotation.operations()).map(o -> o == null ? null : o.toLowerCase()).collect(Collectors.toSet());
        this.allowedTables.put(constraintAnnotation.name().toLowerCase(), operations);
    }

    public boolean isValid(DWDataSet value, ConstraintValidatorContext context) {
        return DWDataTablesValidator.isValid(this.allowedTables, value, context);
    }
}

