/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWDriverConnectionFactory
extends DriverConnectionFactory {
    private static final Log log = LogFactory.getLog(DWDriverConnectionFactory.class);

    public DWDriverConnectionFactory(Driver driver, String connectUri, Properties props) {
        super(driver, connectUri, props);
    }

    public Connection createConnection() throws SQLException {
        Connection conn = null;
        try {
            conn = super.createConnection();
        }
        catch (SQLException e) {
            if (this.unknownHost(e)) {
                int retryTimes;
                int RETRY_TIMES = Integer.parseInt(System.getProperty("dbRetryTimes", "3"));
                long INTERVAL_MILLIS = Long.parseLong(System.getProperty("dbRetryIntervalMillis", "2000"));
                log.warn((Object)("@@ catch unknown host ex, will retry [" + RETRY_TIMES + "] times, begin @@"));
                long backoffMilliseconds = 0L;
                for (retryTimes = 1; retryTimes <= RETRY_TIMES; ++retryTimes) {
                    try {
                        backoffMilliseconds = INTERVAL_MILLIS * (long)retryTimes;
                        log.warn((Object)(" do [" + retryTimes + "] time retry, thread will sleep [" + backoffMilliseconds / 1000L + "] seconds !"));
                        Thread.sleep(backoffMilliseconds);
                        conn = super.createConnection();
                        break;
                    }
                    catch (Exception e1) {
                        continue;
                    }
                }
                if (retryTimes > RETRY_TIMES) {
                    log.warn((Object)("@@ retried " + (retryTimes - 1) + " times, stop retry @@"));
                    throw e;
                }
            }
            throw e;
        }
        return conn;
    }

    private boolean unknownHost(Throwable e) {
        while (Objects.nonNull(e.getCause())) {
            e = e.getCause();
        }
        return e instanceof UnknownHostException;
    }
}

