/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.basic;

import com.digiwin.app.dao.DWBatchDataRowSqlInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.basic.DWBasicDao;
import com.digiwin.app.dao.basic.DWDataSetOperationOptionBuilder;
import com.digiwin.app.dao.dbutils.Aes;
import com.digiwin.app.dao.dbutils.DecryptColumnType;
import com.digiwin.app.dao.dialect.DWMySQLDialect;
import com.digiwin.app.dao.dialect.DWSQLDialect;
import com.digiwin.app.dao.filter.DWResultSetFilterChain;
import com.digiwin.app.dao.filter.IDWResultSetFilter;
import com.digiwin.app.dao.generic.DWGenericDBRowProcessor;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.app.data.DWSQLOptionsBuilder;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.ExecuteException;
import com.digiwin.app.service.DWServiceContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.values.ValuesStatement;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWBasicDaoImpl
implements DWBasicDao {
    private static Log log = LogFactory.getLog(DWBasicDaoImpl.class);
    protected static final RowProcessor DW_GENERIC_DB_ROW_PROCESSOR = new DWGenericDBRowProcessor();
    private QueryRunner queryRunner;
    private DWSQLDialect dialect;
    private DWDaoProperties properties;
    private IDWResultSetFilter resultSetFilter;

    public DWBasicDaoImpl(QueryRunner queryRunner) {
        this.queryRunner = queryRunner;
    }

    @Override
    public QueryRunner getQueryRunner() {
        return this.getQueryRunner(null);
    }

    @Override
    public QueryRunner getQueryRunner(IDWSQLOptions option) {
        return this.queryRunner;
    }

    public void setDialect(DWSQLDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect is null!");
        }
        this.dialect = dialect;
    }

    @Override
    public DWSQLDialect getDialect() {
        if (this.dialect == null) {
            this.dialect = new DWMySQLDialect();
        }
        return this.dialect;
    }

    public void setProperties(DWDaoProperties properties) {
        this.properties = properties;
    }

    @Override
    public DWDaoProperties getProperties() {
        return this.properties;
    }

    public void setDWResultSetFilter(IDWResultSetFilter resultSetFilter) {
        this.resultSetFilter = resultSetFilter;
    }

    public IDWResultSetFilter getDWResultSetFilter() {
        if (this.resultSetFilter == null) {
            this.resultSetFilter = new DWResultSetFilterChain(new ArrayList<IDWResultSetFilter>());
        }
        return this.resultSetFilter;
    }

    @Override
    public List<Map<String, Object>> select(String statement, Object ... params) {
        return this.select(null, statement, params);
    }

    @Override
    public List<Map<String, Object>> select(IDWSQLOptions options, String statement, Object ... params) {
        if (options == null) {
            options = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        options = DWDataSetOperationOptionBuilder.disabledManagementFields(options);
        DWSqlInfo sqlInfo = this.getDialect().parse(options, statement, params);
        return (List)this.innerQuery(sqlInfo, (ResultSetHandler)new MapListHandler(DW_GENERIC_DB_ROW_PROCESSOR), options);
    }

    @Override
    public int update(String statement, Object ... params) {
        return this.update(null, statement, params);
    }

    @Override
    public int update(IDWSQLOptions options, String statement, Object ... params) {
        if (options == null) {
            options = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        DWSqlInfo sqlInfo = this.getDialect().parse(options, statement, params);
        return this.innerUpdate(sqlInfo, options);
    }

    protected <T> T innerQuery(DWSqlInfo sqlInfo, ResultSetHandler<T> resultSetHandler, IDWSQLOptions options) {
        String sql = sqlInfo.getSql();
        Object[] params = sqlInfo.getParameters();
        if (options == null) {
            options = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        try {
            final Map currentDecryptColumnMap = options.get(DWSQLOptionsBuilder.OPTION_DECRYPT, new HashMap());
            if (currentDecryptColumnMap.size() != 0) {
                Statements statements = CCJSqlParserUtil.parseStatements((String)sql);
                Statement statement = (Statement)statements.getStatements().get(0);
                Select select = (Select)statement;
                final String key = Aes.getKey();
                final HashMap aliasMapping = new HashMap();
                SelectBody selectBody = select.getSelectBody();
                if (selectBody != null) {
                    selectBody.accept(new SelectVisitor(){

                        public void visit(PlainSelect plainSelect) {
                            List orderByElements;
                            Expression where;
                            List selectItems = plainSelect.getSelectItems();
                            if (selectItems != null) {
                                for (int i = 0; i < selectItems.size(); ++i) {
                                    SelectItem selectItem = (SelectItem)selectItems.get(i);
                                    selectItem.accept(new SelectItemVisitor(){

                                        public void visit(AllColumns allColumns) {
                                        }

                                        public void visit(AllTableColumns allTableColumns) {
                                        }

                                        public void visit(SelectExpressionItem selectExpressionItem) {
                                            String columnName = selectExpressionItem.getExpression().toString();
                                            String aliasName = "";
                                            Alias alias = selectExpressionItem.getAlias();
                                            if (alias != null) {
                                                aliasName = selectExpressionItem.getAlias().getName();
                                                aliasMapping.put(columnName, aliasName);
                                            } else {
                                                aliasMapping.put(columnName, "");
                                            }
                                            if (currentDecryptColumnMap.containsKey(columnName)) {
                                                try {
                                                    DecryptColumnType decryptColumnType = currentDecryptColumnMap.getOrDefault(columnName, DecryptColumnType.CHAR);
                                                    Expression expression = selectExpressionItem.getExpression();
                                                    String newExpressionString = String.format("CAST(AES_DECRYPT(UNHEX(%s), '%s') AS %s)", new Object[]{expression.toString(), key, decryptColumnType});
                                                    Expression decryptExpression = CCJSqlParserUtil.parseExpression((String)newExpressionString);
                                                    selectExpressionItem.setExpression(decryptExpression);
                                                }
                                                catch (JSQLParserException e) {
                                                    throw new RuntimeException(e);
                                                }
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)aliasName) && currentDecryptColumnMap.containsKey(aliasName)) {
                                                try {
                                                    DecryptColumnType decryptColumnType = currentDecryptColumnMap.getOrDefault(aliasName, DecryptColumnType.CHAR);
                                                    Expression expression = selectExpressionItem.getExpression();
                                                    String newExpressionString = String.format("CAST(AES_DECRYPT(UNHEX(%s), '%s') AS %s)", new Object[]{expression.toString(), key, decryptColumnType});
                                                    Expression decryptExpression = CCJSqlParserUtil.parseExpression((String)newExpressionString);
                                                    selectExpressionItem.setExpression(decryptExpression);
                                                }
                                                catch (JSQLParserException e) {
                                                    throw new RuntimeException(e);
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                            if ((where = plainSelect.getWhere()) != null) {
                                where.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

                                    public void visitBinaryExpression(BinaryExpression expr) {
                                        Expression decryptExpression;
                                        String newExpressionString;
                                        DecryptColumnType decryptColumnType;
                                        String leftExpressionString = expr.getLeftExpression().toString();
                                        String leftExpressionAliasName = aliasMapping.getOrDefault(leftExpressionString, "");
                                        String rightExpressionString = expr.getRightExpression().toString();
                                        String rightExpressionAliasName = aliasMapping.getOrDefault(rightExpressionString, "");
                                        if (currentDecryptColumnMap.containsKey(leftExpressionString) || StringUtils.isNotBlank((CharSequence)leftExpressionAliasName) && currentDecryptColumnMap.containsKey(leftExpressionAliasName)) {
                                            try {
                                                decryptColumnType = currentDecryptColumnMap.getOrDefault(leftExpressionString, currentDecryptColumnMap.getOrDefault(leftExpressionAliasName, DecryptColumnType.CHAR));
                                                newExpressionString = String.format("CAST(AES_DECRYPT(UNHEX(%s), '%s') AS %s)", new Object[]{leftExpressionString, key, decryptColumnType});
                                                decryptExpression = CCJSqlParserUtil.parseExpression((String)newExpressionString);
                                                expr.setLeftExpression(decryptExpression);
                                            }
                                            catch (JSQLParserException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }
                                        if (currentDecryptColumnMap.containsKey(rightExpressionString) || StringUtils.isNotBlank((CharSequence)rightExpressionAliasName) && currentDecryptColumnMap.containsKey(rightExpressionAliasName)) {
                                            try {
                                                decryptColumnType = currentDecryptColumnMap.getOrDefault(rightExpressionString, currentDecryptColumnMap.getOrDefault(rightExpressionAliasName, DecryptColumnType.CHAR));
                                                newExpressionString = String.format("CAST(AES_DECRYPT(UNHEX(%s), '%s') AS %s)", new Object[]{rightExpressionString, key, decryptColumnType});
                                                decryptExpression = CCJSqlParserUtil.parseExpression((String)newExpressionString);
                                                expr.setRightExpression(decryptExpression);
                                            }
                                            catch (JSQLParserException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }
                                        super.visitBinaryExpression(expr);
                                    }
                                });
                            }
                            if ((orderByElements = plainSelect.getOrderByElements()) != null) {
                                for (int i = 0; i < orderByElements.size(); ++i) {
                                    OrderByElement orderByElement = (OrderByElement)orderByElements.get(i);
                                    String orderByColumnName = orderByElement.getExpression().toString();
                                    boolean isAlias = currentDecryptColumnMap.containsKey(orderByColumnName);
                                    if (isAlias) continue;
                                    try {
                                        String aliasName = aliasMapping.getOrDefault(orderByColumnName, "");
                                        DecryptColumnType decryptColumnType = currentDecryptColumnMap.getOrDefault(orderByColumnName, currentDecryptColumnMap.getOrDefault(aliasName, DecryptColumnType.CHAR));
                                        String newExpressionString = String.format("CAST(AES_DECRYPT(UNHEX(%s), '%s') AS %s)", new Object[]{orderByColumnName, key, decryptColumnType});
                                        Expression decryptExpression = CCJSqlParserUtil.parseExpression((String)newExpressionString);
                                        orderByElement.setExpression(decryptExpression);
                                        orderByElements.set(i, orderByElement);
                                        continue;
                                    }
                                    catch (JSQLParserException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }
                        }

                        public void visit(SetOperationList setOpList) {
                        }

                        public void visit(WithItem withItem) {
                        }

                        public void visit(ValuesStatement aThis) {
                        }
                    });
                }
                String newSql = select.toString();
                Field sqlField = DWSqlInfo.class.getDeclaredField("sql");
                sqlField.setAccessible(true);
                sqlField.set(sqlInfo, newSql);
                sql = newSql;
            }
            this.logSqlExecutingInfo(options, sqlInfo);
            QueryRunner queryRunner = this.getQueryRunner(options);
            Object result = queryRunner.query(sql, resultSetHandler, params);
            this.getDWResultSetFilter().doFilter(result, options);
            return (T)result;
        }
        catch (UnsupportedEncodingException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | NoSuchAlgorithmException | SQLException | JSQLParserException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
    }

    protected int innerUpdate(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        int result = 0;
        Object[] params = sqlInfo.getParameters();
        if (options == null) {
            options = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        try {
            String sql = sqlInfo.getSql();
            String newSql = this.attachEncrypt(sql, options);
            Field sqlField = DWSqlInfo.class.getDeclaredField("sql");
            sqlField.setAccessible(true);
            sqlField.set(sqlInfo, newSql);
            this.logSqlExecutingInfo(options, sqlInfo);
            QueryRunner queryRunner = this.getQueryRunner(options);
            result = queryRunner.update(newSql, params);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | SQLException | JSQLParserException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        return result;
    }

    protected int[] innerBatch(DWBatchDataRowSqlInfo batchSqlInfo, IDWSQLOptions options) {
        int[] batchResult = new int[]{};
        if (options == null) {
            options = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        try {
            String sql = batchSqlInfo.getSql();
            String newSql = this.attachEncrypt(sql, options);
            Field sqlField = DWSqlInfo.class.getDeclaredField("sql");
            sqlField.setAccessible(true);
            sqlField.set(batchSqlInfo, newSql);
            this.logSqlExecutingInfo(options, batchSqlInfo);
            QueryRunner queryRunner = this.getQueryRunner(options);
            batchResult = queryRunner.batch(newSql, batchSqlInfo.getBatchParameters());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | SQLException | JSQLParserException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        return batchResult;
    }

    protected List<Map<String, Object>> innerInsert(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        List result;
        if (options == null) {
            options = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        try {
            String sql = sqlInfo.getSql();
            String newSql = this.attachEncrypt(sql, options);
            Field sqlField = DWSqlInfo.class.getDeclaredField("sql");
            sqlField.setAccessible(true);
            sqlField.set(sqlInfo, newSql);
            this.logSqlExecutingInfo(options, sqlInfo);
            QueryRunner queryRunner = this.getQueryRunner(options);
            result = (List)queryRunner.insert(newSql, (ResultSetHandler)new MapListHandler(), sqlInfo.getParameters());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | SQLException | JSQLParserException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        return result;
    }

    protected List<Map<String, Object>> innerInsertBatch(DWBatchDataRowSqlInfo batchSqlInfo, IDWSQLOptions options) {
        List result;
        if (options == null) {
            options = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        try {
            String sql = batchSqlInfo.getSql();
            String newSql = this.attachEncrypt(sql, options);
            Field sqlField = DWSqlInfo.class.getDeclaredField("sql");
            sqlField.setAccessible(true);
            sqlField.set(batchSqlInfo, newSql);
            this.logSqlExecutingInfo(options, batchSqlInfo);
            QueryRunner queryRunner = this.getQueryRunner(options);
            result = (List)queryRunner.insertBatch(newSql, (ResultSetHandler)new MapListHandler(), batchSqlInfo.getBatchParameters());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | SQLException | JSQLParserException e) {
            this.logStackTrace(e);
            throw new ExecuteException(e);
        }
        return result;
    }

    protected void logStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String stackTrace = stringWriter.toString();
        log.error((Object)stackTrace);
    }

    protected void logSqlExecutingInfo(IDWSQLOptions option, DWSqlInfo sqlInfo) {
        StringBuilder parameterInfo = new StringBuilder();
        Object[] parameters = sqlInfo.getParameters();
        int seq = 0;
        int count = parameters.length;
        for (Object p : parameters) {
            parameterInfo.append(p);
            if (p == null) {
                parameterInfo.append("(Unknown)");
            } else {
                parameterInfo.append("(").append(p.getClass().getSimpleName()).append(")");
            }
            if (++seq == count) continue;
            parameterInfo.append(", ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[SQL.statement]" + sqlInfo.getSql()));
            log.debug((Object)("[SQL.params]" + parameterInfo.toString()));
        }
        this.operateSqlLogCollector(option, sqlInfo.getSql(), parameters);
    }

    protected void logSqlExecutingInfo(IDWSQLOptions option, DWBatchDataRowSqlInfo batchSqlInfo) {
        StringBuilder parameterInfo = new StringBuilder();
        List<List<Object>> batchRowParameters = batchSqlInfo.getBatchParametersAsList();
        ArrayList<Object> totalParameters = new ArrayList<Object>();
        int rowNo = 1;
        for (List<Object> batchRowParameter : batchRowParameters) {
            int seq = 0;
            int count = batchRowParameter.size();
            parameterInfo.append("[row=" + rowNo + "]");
            for (Object p : batchRowParameter) {
                totalParameters.add(p);
                parameterInfo.append(p);
                if (p == null) {
                    parameterInfo.append("(Unknown)");
                } else {
                    parameterInfo.append("(").append(p.getClass().getSimpleName()).append(")");
                }
                if (++seq == count) continue;
                parameterInfo.append(", ");
            }
            ++rowNo;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[SQL.statement]" + batchSqlInfo.getSql()));
            log.debug((Object)("[SQL.params]" + parameterInfo.toString()));
        }
        this.operateSqlLogCollector(option, batchSqlInfo.getSql(), totalParameters.toArray());
    }

    private void operateSqlLogCollector(IDWSQLOptions dwSqlOption, String sql, Object ... params) {
        boolean mergedLogBasicEnabled = false;
        boolean mergedLogSqlEnabled = false;
        Map operateLogMap = DWServiceContext.getContext().getOperateLog();
        if (!(MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("isLogRecord") && operateLogMap.containsKey("isLogSqlRecord"))) {
            return;
        }
        mergedLogBasicEnabled = (Boolean)operateLogMap.get("isLogRecord");
        mergedLogSqlEnabled = (Boolean)operateLogMap.get("isLogSqlRecord");
        if (mergedLogBasicEnabled && mergedLogSqlEnabled) {
            boolean dataSetOptionLogSqlEnabled = false;
            boolean daoOptionValueOfOperateLogEnabled = true;
            dataSetOptionLogSqlEnabled = dwSqlOption != null ? (daoOptionValueOfOperateLogEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)dwSqlOption.get(DWSQLOptionsBuilder.OPTION_LOG_OPERATION_ENABLED)), (boolean)true)) : true;
            if (dataSetOptionLogSqlEnabled) {
                HashMap<String, Object> currentSqlMap = new HashMap<String, Object>();
                currentSqlMap.put("statement", sql);
                currentSqlMap.put("parameters", Arrays.asList(params));
                HashMap<Integer, HashMap<Integer, HashMap<String, Object>>> logRecordSqlMap = (HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>)operateLogMap.get("sqlMap");
                if (MapUtils.isNotEmpty((Map)logRecordSqlMap)) {
                    logRecordSqlMap.put(logRecordSqlMap.size() + 1, currentSqlMap);
                } else {
                    logRecordSqlMap = new HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>();
                    logRecordSqlMap.put(1, currentSqlMap);
                    operateLogMap.put("sqlMap", logRecordSqlMap);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("dataSetOptionLogSqlEnabled=%b (mergedLogBasicEnabled=%b, mergedLogSqlEnabled=%b, daoOptionValueOfOperateLogEnabled=%s !)", dataSetOptionLogSqlEnabled, mergedLogBasicEnabled, mergedLogSqlEnabled, daoOptionValueOfOperateLogEnabled));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("mergedLogBasicEnabled=%b mergedLogSqlEnabled=%b ", mergedLogBasicEnabled, mergedLogSqlEnabled));
        }
    }

    private String attachEncrypt(String sql, IDWSQLOptions options) throws JSQLParserException {
        Set encryptColumnNameSet = options.get(DWSQLOptionsBuilder.OPTION_ENCRYPT, new HashSet());
        if (encryptColumnNameSet.size() == 0) {
            return sql;
        }
        Statements statements = CCJSqlParserUtil.parseStatements((String)sql);
        Statement statement = (Statement)statements.getStatements().get(0);
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            String newSql = this.attachInsertEncrypt(insert, encryptColumnNameSet);
            return newSql;
        }
        if (statement instanceof Update) {
            Update update = (Update)statement;
            String newSql = this.attachUpdateEncrypt(update, encryptColumnNameSet);
            return newSql;
        }
        return sql;
    }

    private String attachInsertEncrypt(Insert insert, Set<String> encryptColumnNameSet) throws JSQLParserException {
        List columns = insert.getColumns();
        final HashSet<Integer> targetIndexs = new HashSet<Integer>();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            String columnName = column.getColumnName();
            if (!encryptColumnNameSet.contains(columnName)) continue;
            targetIndexs.add(i);
        }
        final ArrayList jSQLParserExceptionList = new ArrayList();
        insert.getItemsList().accept(new ItemsListVisitor(){

            public void visit(SubSelect subSelect) {
            }

            public void visit(ExpressionList expressionList) {
                try {
                    String key = Aes.getKey();
                    Iterator iterator = targetIndexs.iterator();
                    while (iterator.hasNext()) {
                        int targetIndex = (Integer)iterator.next();
                        Expression expression = (Expression)expressionList.getExpressions().get(targetIndex);
                        Expression encryptExpression = CCJSqlParserUtil.parseExpression((String)String.format("HEX(AES_ENCRYPT(%s, '%s'))", expression.toString(), key));
                        expressionList.getExpressions().set(targetIndex, encryptExpression);
                    }
                }
                catch (JSQLParserException e) {
                    jSQLParserExceptionList.add(e);
                    return;
                }
                catch (NoSuchAlgorithmException e) {
                    jSQLParserExceptionList.add(new JSQLParserException((Throwable)e));
                    return;
                }
                catch (UnsupportedEncodingException e) {
                    jSQLParserExceptionList.add(new JSQLParserException((Throwable)e));
                    return;
                }
            }

            public void visit(MultiExpressionList multiExprList) {
            }

            public void visit(NamedExpressionList namedExpressionList) {
            }
        });
        if (jSQLParserExceptionList.size() > 0) {
            JSQLParserException e = (JSQLParserException)((Object)jSQLParserExceptionList.get(0));
            throw e;
        }
        String newSql = insert.toString();
        return newSql;
    }

    private String attachUpdateEncrypt(Update update, Set<String> encryptColumnNameSet) throws JSQLParserException {
        List columns = update.getColumns();
        HashSet<Integer> targetIndexs = new HashSet<Integer>();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            String columnName = column.getColumnName();
            if (!encryptColumnNameSet.contains(columnName)) continue;
            targetIndexs.add(i);
        }
        List expressions = update.getExpressions();
        try {
            String key = Aes.getKey();
            Iterator iterator = targetIndexs.iterator();
            while (iterator.hasNext()) {
                int targetIndex = (Integer)iterator.next();
                Expression expression = (Expression)expressions.get(targetIndex);
                Expression encryptExpression = CCJSqlParserUtil.parseExpression((String)String.format("HEX(AES_ENCRYPT(%s, '%s'))", expression.toString(), key));
                expressions.set(targetIndex, encryptExpression);
            }
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new JSQLParserException((Throwable)e);
        }
        String newSql = update.toString();
        return newSql;
    }
}

