/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.generic;

import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;

public class DWGenericDBRowProcessor
extends BasicRowProcessor {
    public DWGenericDBRowProcessor() {
    }

    public DWGenericDBRowProcessor(BeanProcessor convert) {
        super(convert);
    }

    public Map<String, Object> toMap(ResultSet rs) throws SQLException {
        CaseInsensitiveHashMap result = new CaseInsensitiveHashMap();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            Object value;
            String columnName = rsmd.getColumnLabel(i);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(i);
            }
            if ((value = rs.getObject(i)) instanceof Clob) {
                value = ((Clob)value).getSubString(1L, (int)((Clob)value).length());
            }
            result.put(columnName, value);
        }
        return result;
    }

    private static class CaseInsensitiveHashMap
    extends LinkedHashMap<String, Object> {
        private final Map<String, String> lowerCaseMap = new HashMap<String, String>();
        private static final long serialVersionUID = -2848100435296897392L;

        private CaseInsensitiveHashMap() {
        }

        @Override
        public boolean containsKey(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
            return super.containsKey(realKey);
        }

        @Override
        public Object get(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
            return super.get(realKey);
        }

        @Override
        public Object put(String key, Object value) {
            String oldKey = this.lowerCaseMap.put(key.toLowerCase(Locale.ENGLISH), key);
            Object oldValue = super.remove(oldKey);
            super.put(key, value);
            return oldValue;
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.put(key, value);
            }
        }

        @Override
        public Object remove(Object key) {
            String realKey = this.lowerCaseMap.remove(key.toString().toLowerCase(Locale.ENGLISH));
            return super.remove(realKey);
        }
    }
}

