/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.generic;

import com.digiwin.app.dao.generic.DWGenericDBRowProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.dbutils.BeanProcessor;

public class DWRowProcessor
extends DWGenericDBRowProcessor {
    private List<String> selectFields;
    static String[] keywords = new String[]{" AS ", " As ", " aS ", " as "};

    public DWRowProcessor() {
    }

    public DWRowProcessor(BeanProcessor convert) {
        super(convert);
    }

    public void setSelectFields(List<String> selectFields) {
        this.selectFields = selectFields;
    }

    @Override
    public Map<String, Object> toMap(ResultSet rs) throws SQLException {
        CaseInsensitiveHashMap result = super.toMap(rs);
        if (this.selectFields != null && !this.selectFields.isEmpty()) {
            String selectFieldAfterFetched;
            CaseInsensitiveHashMap resultBySelectFields = new CaseInsensitiveHashMap();
            for (String selectField : this.selectFields) {
                selectFieldAfterFetched = this.fetchFieldNameAfterAs(selectField);
                selectFieldAfterFetched = this.fetchFieldNameAfterSpace(selectFieldAfterFetched);
                selectFieldAfterFetched = this.fetchFieldNameAfterDot(selectFieldAfterFetched);
                resultBySelectFields.put(selectFieldAfterFetched, result.get(selectFieldAfterFetched));
            }
            if (result != null && result.size() > this.selectFields.size()) {
                for (String rsField : result.keySet()) {
                    if (resultBySelectFields.containsKey(rsField)) continue;
                    selectFieldAfterFetched = this.fetchFieldNameAfterAs(rsField);
                    selectFieldAfterFetched = this.fetchFieldNameAfterSpace(selectFieldAfterFetched);
                    selectFieldAfterFetched = this.fetchFieldNameAfterDot(selectFieldAfterFetched);
                    resultBySelectFields.put(selectFieldAfterFetched, result.get(selectFieldAfterFetched));
                }
            }
            result = resultBySelectFields;
        }
        return result;
    }

    private String fetchFieldNameAfterAs(String fieldName) {
        String result = fieldName;
        for (String keyword : keywords) {
            if (!fieldName.contains(keyword)) continue;
            result = fieldName.split(keyword)[1].trim();
        }
        return result;
    }

    private String fetchFieldNameAfterSpace(String fieldName) {
        String result = fieldName;
        if ((result = result.trim()).contains(" ")) {
            result = result.split("\\s+")[1].trim();
        }
        return result;
    }

    private String fetchFieldNameAfterDot(String fieldName) {
        String result = fieldName;
        String keyword = ".";
        String splitKeyword = "\\" + keyword;
        if (fieldName.contains(keyword)) {
            result = fieldName.split(splitKeyword)[1].trim();
        }
        return result;
    }

    private static class CaseInsensitiveHashMap
    extends LinkedHashMap<String, Object> {
        private final Map<String, String> lowerCaseMap = new HashMap<String, String>();
        private static final long serialVersionUID = -2848100435296897392L;

        private CaseInsensitiveHashMap() {
        }

        @Override
        public boolean containsKey(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
            return super.containsKey(realKey);
        }

        @Override
        public Object get(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
            return super.get(realKey);
        }

        @Override
        public Object put(String key, Object value) {
            String oldKey = this.lowerCaseMap.put(key.toLowerCase(Locale.ENGLISH), key);
            Object oldValue = super.remove(oldKey);
            super.put(key, value);
            return oldValue;
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.put(key, value);
            }
        }

        @Override
        public Object remove(Object key) {
            String realKey = this.lowerCaseMap.remove(key.toString().toLowerCase(Locale.ENGLISH));
            return super.remove(realKey);
        }
    }
}

