/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.filter.DWAbstractFieldNameResolver;
import com.digiwin.app.dao.filter.DWFieldNameResolverFactory;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSetInsertOption;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWFieldValueFilter
implements IDWSQLFilter {
    private static Log log = LogFactory.getLog(DWFieldValueFilter.class);
    public static String OPTION_FIXED_FIELD_VALUE_GENERATE_ENABLED = "fixedFieldValueGeneratorEnabled";
    private List<DWDataSetInsertOption.DWFieldValueGeneratorSetting> fixedFieldValueGeneratorSettings;

    public void setFixedFieldValueGeneratorSettings(List<DWDataSetInsertOption.DWFieldValueGeneratorSetting> fixedFieldValueGeneratorSettings) {
        this.fixedFieldValueGeneratorSettings = fixedFieldValueGeneratorSettings;
    }

    @Override
    public void doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options) {
    }

    @Override
    public void doFilter(DWQueryInfo queryInfo, IDWSQLOptions options) {
    }

    @Override
    public void doFilter(DWDataRow dataRow, IDWSQLOptions options) {
        if (options instanceof DWDataSetOperationOption) {
            DWDataSetOperationOption dwDataSetOperationOption = (DWDataSetOperationOption)options;
            DWDataSetInsertOption insertOption = dwDataSetOperationOption.getInsertOption();
            List<DWDataSetInsertOption.DWFieldValueGeneratorSetting> fieldValueGeneratorSettings = insertOption.getFieldValueGeneratorSettings();
            for (DWDataSetInsertOption.DWFieldValueGeneratorSetting setting : fieldValueGeneratorSettings) {
                String fieldName = setting.getFieldName();
                Object fieldValue = setting.getGenerator().generate(dataRow);
                dataRow.set(fieldName, fieldValue);
            }
        }
        if (this.isEnabled(options) && "C".equalsIgnoreCase(dataRow.getState())) {
            for (DWDataSetInsertOption.DWFieldValueGeneratorSetting setting : this.fixedFieldValueGeneratorSettings) {
                String fieldName = this.getRealName(setting, dataRow);
                if (StringUtils.isEmpty((CharSequence)fieldName) || dataRow.get(fieldName) != null) continue;
                Object fieldValue = setting.getGenerator().generate(dataRow);
                dataRow.set(fieldName, fieldValue);
            }
        }
    }

    private boolean isEnabled(IDWSQLOptions options) {
        boolean fixedEnable;
        boolean bl = fixedEnable = this.fixedFieldValueGeneratorSettings != null;
        if (options == null) {
            return fixedEnable;
        }
        return options.get(OPTION_FIXED_FIELD_VALUE_GENERATE_ENABLED, true) != false && fixedEnable;
    }

    private String getRealName(DWDataSetInsertOption.DWFieldValueGeneratorSetting setting, DWDataRow dataRow) {
        DWAbstractFieldNameResolver fieldNameResolver = DWFieldNameResolverFactory.getResolver(setting.getFieldName());
        if (fieldNameResolver == null) {
            log.error((Object)("\u83b7\u53d6\u5b57\u6bb5\u540d\u79f0\u89e3\u6790\u5668\u5f02\u5e38\uff0cfieldName:" + setting.getFieldName()));
            return null;
        }
        return fieldNameResolver.getRealName(dataRow);
    }
}

