/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dashboard.service.impl;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.dashboard.service.IScreenService;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.resource.DWModuleMessageResourceBundleUtils;
import com.digiwin.utils.DWTenantUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class ScreenService
implements IScreenService {
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    private static final String _tag_Tenantsid = DWTenantUtils.getTenantTagByColumnName();
    private static final String _tag_Ignore_Tenantsid = DWTenantUtils.getTenantIgnoreTagByColumnName();
    private static final String _TABLE_MASTER = "dw_screen";
    private static final String _TABLE_DETAIL = "dw_screen_unit";
    private static final String _TABLE_EXTRA = "dw_screen_extra";
    private static final String _TABLE_PRESET = "dw_screen_preset";
    private static final String _Param_Screen = "dw_screen";
    private static final String _Screen_Id = "screen_id";
    private static final String _Screen_Name = "screen_name";
    private static final String _Screen_Modify_Date = "modify_date";
    private static final String _Screen_Type = "screen_type";
    private static final String _Key_Screen_Type_Std = "std";
    private static final String _Param_Unit = "dw_screen_unit";
    private static final String _Unit_Id = "unit_id";
    private static final String _Unit_Name = "unit_name";
    private static final String _Unit_Chain_Id = "chain_id";
    private static final String _Extra_Screen_Default = "screen_default";
    private static final String _Extra_Screen_Default_Value = "Y";
    private static final String _Extra_Screen_NotDefault_Value = "N";
    private static final String _Param_PreSet = "dw_screen_preset";
    private static final String _SQL_ScreenService_delete_units_by_screen = " delete from dw_screen_unit where screen_id = ? " + _tag_Tenantsid + " ";
    private static final String _SQL_ScreenService_delete_screen_of_default = " delete from dw_screen_extra where screen_default= 'Y' " + _tag_Tenantsid + " ";
    private static final String _SQL_ScreenService_select_screen_of_chainId = " select screen.screen_name, screen.screen_type, unit.screen_id, unit.unit_name, unit.unit_id from dw_screen_unit as unit, dw_screen as screen  where unit.screen_id = screen.screen_id and unit.chain_id =  ? " + _tag_Ignore_Tenantsid + " ";
    private static final String _SQL_ScreenService_update_chain_of_unit = " update dw_screen_unit set chain_id = null  where chain_id = ? " + _tag_Tenantsid + " ";
    private static final String _SQL_ScreenService_select_screen = " select * from dw_screen where 1=1 " + _tag_Tenantsid + " or " + "screen_type" + " = '" + "std" + "' " + " ORDER BY modify_date desc ";

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object post(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        Map screenMap = (Map)paramsMap.get("dw_screen");
        this.checkParam(screenMap, "post");
        screenMap.put("$state", "C");
        String screenId = "";
        String screenType = (String)screenMap.get(_Screen_Type);
        if (!_Key_Screen_Type_Std.equals(screenType)) {
            screenId = this.genScreenId();
        } else {
            Object screenIdObj = screenMap.get(_Screen_Id);
            if (screenIdObj != null) {
                screenId = (String)screenMap.get(_Screen_Id);
            }
            if (StringUtils.isBlank((CharSequence)screenId)) {
                return DWServiceResultBuilder.build((boolean)false, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg011", (Object[])new Object[]{"msg011"}), (Object)"screen_id format error when screen_type is 'std'");
            }
        }
        screenMap.put(_Screen_Id, screenId);
        DWDataSet dataset = new DWDataSet();
        DWDataTable screenDWTable = dataset.newTable("dw_screen");
        screenDWTable.newRow(screenMap);
        if (paramsMap.containsKey("dw_screen_unit")) {
            DWDataTable unitDWTable = dataset.newTable("dw_screen_unit");
            List unitListMap = (List)paramsMap.get("dw_screen_unit");
            for (Map unitMap : unitListMap) {
                if (!unitMap.containsKey(_Screen_Id)) {
                    unitMap.put(_Screen_Id, screenId);
                }
                DWDataRow unitRow = unitDWTable.newRow(unitMap);
                unitRow.set("$state", (Object)"C");
            }
        }
        DWSQLExecutionResult result = this.dao.execute(dataset);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[]{"msg001"}), (Object)result);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object put(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        Map screenMap = (Map)paramsMap.get("dw_screen");
        String screenId = "";
        if (!screenMap.containsKey(_Screen_Id)) {
            throw new DWArgumentException(_Screen_Id, "screen_id is not existed!");
        }
        screenId = screenMap.get(_Screen_Id);
        LocalDateTime modifyDateTime = LocalDateTime.now();
        screenMap.put(_Screen_Modify_Date, modifyDateTime);
        DWDataSet dataset = new DWDataSet();
        DWDataTable screenDWTable = dataset.newTable("dw_screen");
        DWDataRow screenRow = screenDWTable.newRow(screenMap);
        screenRow.set("$state", (Object)"U");
        if (paramsMap.containsKey("dw_screen_unit")) {
            DWDataTable unitDWTable = dataset.newTable("dw_screen_unit");
            this.dao.update(_SQL_ScreenService_delete_units_by_screen, new Object[]{screenId});
            List unitListMap = (List)paramsMap.get("dw_screen_unit");
            for (Map unitMap : unitListMap) {
                DWDataRow unitRow = unitDWTable.newRow(unitMap);
                unitRow.set(_Screen_Id, (Object)screenId);
                unitRow.set("$state", (Object)"C");
            }
        }
        DWSQLExecutionResult result = this.dao.execute(dataset);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[]{"msg001"}), (Object)result);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object delete(Object params) throws Exception {
        this.checkParam(params);
        DWSQLExecutionResult result = new DWSQLExecutionResult();
        Map paramsMap = (Map)params;
        if (paramsMap.containsKey(_Screen_Id)) {
            Object screenId = paramsMap.get(_Screen_Id);
            DWDataSet dataset = new DWDataSet();
            DWDataTable screenDWTable = dataset.newTable("dw_screen");
            screenDWTable.newRow().set(_Screen_Id, screenId).set("$state", (Object)"D");
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.addCascadeDeleting("dw_screen", "dw_screen_unit");
            option.addCascadeDeleting("dw_screen", _TABLE_EXTRA);
            result = this.dao.execute(dataset, option);
            this.dao.update(_SQL_ScreenService_update_chain_of_unit, new Object[]{screenId});
        }
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[]{"msg001"}), (Object)result);
    }

    @Override
    public Object getList() throws Exception {
        HashMap result = new HashMap();
        ArrayList<Map> resultMaster = new ArrayList<Map>();
        List dwScreenResult = this.dao.select(_SQL_ScreenService_select_screen, new Object[0]);
        if (dwScreenResult != null && dwScreenResult.size() > 0) {
            DWDataSet datasetExtra = this.getExtra();
            DWDataRowCollection rowCollect = datasetExtra.getTable(_TABLE_EXTRA).getRows();
            String screenIdDefault = "";
            String screenIdMaster = "";
            if (rowCollect.size() > 0) {
                DWDataRow defaultrow = rowCollect.get(0);
                screenIdDefault = (String)defaultrow.get(_Screen_Id);
            }
            List<Object> detailRowList = new ArrayList();
            for (Map masterRow : dwScreenResult) {
                HashMap resultDetail = new HashMap();
                screenIdMaster = (String)masterRow.get(_Screen_Id);
                if (screenIdDefault != null) {
                    if (screenIdMaster.equals(screenIdDefault)) {
                        masterRow.put(_Extra_Screen_Default, _Extra_Screen_Default_Value);
                    } else {
                        masterRow.put(_Extra_Screen_Default, _Extra_Screen_NotDefault_Value);
                    }
                } else {
                    masterRow.put(_Extra_Screen_Default, _Extra_Screen_NotDefault_Value);
                }
                DWDataSet dwScreenDetailResult = this.getDetail(screenIdMaster);
                DWDataRowCollection tempScreenDetail = dwScreenDetailResult.getTable("dw_screen_unit").getRows();
                detailRowList = this.dataTableToList(tempScreenDetail);
                resultDetail.put("dw_screen_unit", detailRowList);
                masterRow.put("child", resultDetail);
                resultMaster.add(masterRow);
            }
        }
        result.put("dw_screen", resultMaster);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[]{"msg001"}), result);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object putDefault(Object params) throws Exception {
        DWSQLExecutionResult result = new DWSQLExecutionResult();
        HashMap paramsMap = params == null ? new HashMap() : (HashMap)params;
        int i = this.dao.update(_SQL_ScreenService_delete_screen_of_default, new Object[0]);
        if (paramsMap.size() == 0) {
            ArrayList<Integer> sqlresult = new ArrayList<Integer>();
            sqlresult.add(i);
            result.addGeneratedKeys(_TABLE_EXTRA, sqlresult);
        } else {
            DWDataSet dataset = new DWDataSet();
            DWDataRow cleanScreenDefaultFlagRow = dataset.newTable(_TABLE_EXTRA).newRow();
            cleanScreenDefaultFlagRow.set(_Screen_Id, paramsMap.get(_Screen_Id));
            cleanScreenDefaultFlagRow.set("$state", (Object)"C");
            result = this.dao.execute(dataset);
        }
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[]{"msg001"}), (Object)result);
    }

    @Override
    public Object get(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        String screenType = "";
        if (!paramsMap.containsKey(_Screen_Id)) {
            throw new DWArgumentException(_Screen_Id, "screen_id is not existed!");
        }
        Object screenId = paramsMap.get(_Screen_Id);
        screenType = (String)paramsMap.get(_Screen_Type);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_screen");
        queryInfo.addEqualInfo(_Screen_Id, screenId);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        if (_Key_Screen_Type_Std.equals(screenType)) {
            option.setTenantEnabled(false);
            queryInfo.addEqualInfo(_Screen_Type, (Object)screenType);
        }
        option.addCascadeQuery("dw_screen", "dw_screen_unit");
        option.addCascadeQuery("dw_screen", _TABLE_EXTRA);
        DWDataSet dataset = this.dao.select(queryInfo, option);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[]{"msg001"}), (Object)dataset);
    }

    @Override
    public Object getDefault(Object params) throws Exception {
        this.checkParam(params);
        ArrayList<String> selFileds = new ArrayList<String>();
        selFileds.add(_Screen_Id);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setSelectFields(selFileds);
        queryInfo.setTableName(_TABLE_EXTRA);
        queryInfo.addEqualInfo(_Extra_Screen_Default, (Object)_Extra_Screen_Default_Value);
        DWDataSet dataset = this.dao.select(queryInfo);
        DWDataRowCollection rowCollect = dataset.getTable(_TABLE_EXTRA).getRows();
        DWDataSet datasetMaster = new DWDataSet();
        if (rowCollect.size() > 0) {
            DWDataRow defaultrow = rowCollect.get(0);
            Object screenId = defaultrow.get(_Screen_Id);
            DWQueryInfo queryInfoMaster = new DWQueryInfo();
            queryInfoMaster.setTableName("dw_screen");
            queryInfoMaster.addEqualInfo(_Screen_Id, screenId);
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            option.addCascadeQuery("dw_screen", "dw_screen_unit");
            datasetMaster = this.dao.select(queryInfoMaster, option);
        }
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[]{"msg001"}), (Object)datasetMaster);
    }

    private void checkParam(Object params) throws Exception {
        if (params == null) {
            throw new DWArgumentException("params", "params is null!");
        }
    }

    private void checkParam(Object obj, String function) throws Exception {
        switch (function) {
            case "post": {
                Map paramsMap;
                if (!(obj instanceof Map) || (paramsMap = (Map)obj).containsKey(_Screen_Type)) break;
                throw new DWArgumentException("params", "screen_type is missing!");
            }
            default: {
                if (obj != null) break;
                throw new DWArgumentException("params", "params is null!");
            }
        }
    }

    @Override
    public Object getRelation(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        Object screenId = null;
        if (paramsMap.containsKey(_Screen_Id)) {
            screenId = paramsMap.get(_Screen_Id);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object chain = this.getChainByScreen(screenId);
        result.put("chain", chain);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[]{"msg001"}), result);
    }

    public Object getChainByScreen(Object screenId) throws Exception {
        List result = this.dao.select(_SQL_ScreenService_select_screen_of_chainId, new Object[]{screenId});
        return result;
    }

    private DWDataSet getExtra() throws Exception {
        DWDataSet dataset = new DWDataSet();
        DWQueryInfo queryInfoMaster = new DWQueryInfo();
        queryInfoMaster.setTableName(_TABLE_EXTRA);
        dataset = this.dao.select(queryInfoMaster);
        return dataset;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object postPreSet(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        Map preSetMap = (Map)paramsMap.get("dw_screen_preset");
        DWDataSet dataset = new DWDataSet();
        DWDataTable screenDWTable = dataset.newTable("dw_screen_preset");
        preSetMap.put("$state", "C");
        screenDWTable.newRow(preSetMap);
        DWSQLExecutionResult result = this.dao.execute(dataset);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[]{"msg001"}), (Object)result);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object putPreSet(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        Map preSetMap = (Map)paramsMap.get("dw_screen_preset");
        DWDataSet dataset = new DWDataSet();
        DWDataTable screenDWTable = dataset.newTable("dw_screen_preset");
        preSetMap.put("$state", "U");
        screenDWTable.newRow(preSetMap);
        DWSQLExecutionResult result = this.dao.execute(dataset);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[]{"msg001"}), (Object)result);
    }

    @Override
    public Object getPreSet() throws Exception {
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_screen_preset");
        DWDataSet dataset = this.dao.select(queryInfo);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[]{"msg001"}), (Object)dataset);
    }

    private String genScreenId() {
        String result = "";
        UUID uuid = UUID.randomUUID();
        result = uuid.toString();
        return result;
    }

    public DWDataSet getDetail(String screenId) throws Exception {
        if (StringUtils.isBlank((CharSequence)screenId)) {
            throw new DWArgumentException(_Screen_Id, "screen_id is not existed!");
        }
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_screen_unit");
        queryInfo.addEqualInfo(_Screen_Id, (Object)screenId);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        DWDataSet dataset = this.dao.select(queryInfo, option);
        return dataset;
    }

    public List<Map<String, Object>> dataTableToList(DWDataRowCollection dwDataRowCollection) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map rowMap = new HashMap();
        for (DWDataRow dwDataRow : dwDataRowCollection) {
            rowMap = dwDataRow.getData();
            result.add(rowMap);
        }
        return result;
    }
}

