/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dashboard.weather;

import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.common.DWPropertiesUtils;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.dashboard.DWDashboardConstants;
import com.digiwin.app.dashboard.weather.IWeatherProvider;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWModulePropertiesUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeatherConfig {
    private static Log _log = LogFactory.getLog(WeatherConfig.class);
    private static String _CLASSTAG = "[WeatherConfig] ";
    private static String defaultProviderClassName = "com.digiwin.app.dashboard.weather.DefaultWeatherProvider";
    private String providerClassName;
    private String baseUrl;
    private static WeatherConfig weatherConfig;

    public static void init() throws DWArgumentException {
        if (weatherConfig == null) {
            weatherConfig = WeatherConfig.getInstance();
        }
    }

    public static WeatherConfig getInstance() {
        if (weatherConfig != null) {
            return weatherConfig;
        }
        String className = "";
        String apiUrl = "";
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        if (!DWDashboardConstants.Platform_Modules.contains(moduleName)) {
            className = DWModulePropertiesUtils.getCurrentModuleProperty((String)"module", (String)"dashBoardWeatherProviderClassName", (String)defaultProviderClassName);
            apiUrl = DWModulePropertiesUtils.getCurrentModuleProperty((String)"module", (String)"dashBoardWeatherBaseUrl");
        } else {
            className = DWPropertiesUtils.getPlatformModuleProperty((String)"module", (String)moduleName, (String)"dashBoardWeatherProviderClassName", (String)defaultProviderClassName);
            apiUrl = DWPropertiesUtils.getPlatformModuleProperty((String)"module", (String)moduleName, (String)"dashBoardWeatherBaseUrl");
        }
        weatherConfig = new WeatherConfig();
        weatherConfig.setProviderClassName(className);
        weatherConfig.setBaseUrl(apiUrl);
        return weatherConfig;
    }

    public IWeatherProvider getWeatherProvider() {
        IWeatherProvider result = null;
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        try {
            if (StringUtils.isNotBlank((CharSequence)this.providerClassName)) {
                _log.debug((Object)(_CLASSTAG + "processing for '" + moduleName + "', creating " + this.providerClassName));
                Class resolverClass = DWApplicationClassLoader.getInstance().loadClass(this.providerClassName);
                result = (IWeatherProvider)resolverClass.newInstance();
                _log.debug((Object)(_CLASSTAG + moduleName + " created " + this.providerClassName + " successful"));
            }
        }
        catch (Exception e) {
            String message = _CLASSTAG + moduleName + " created " + this.providerClassName + " failed";
            _log.error((Object)message, (Throwable)e);
            throw new DWRuntimeException(message, (Throwable)e);
        }
        return result;
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public void setProviderClassName(String providerClassName) {
        this.providerClassName = providerClassName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public static WeatherConfig getWeatherConfig() {
        return weatherConfig;
    }

    public static void setWeatherConfig(WeatherConfig weatherConfig) {
        WeatherConfig.weatherConfig = weatherConfig;
    }

    static {
        try {
            WeatherConfig.init();
        }
        catch (Exception e) {
            _log.info((Object)(_CLASSTAG + " init() error"), (Throwable)e);
        }
    }
}

