/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dashboard.weather;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.dashboard.weather.IWeatherProvider;
import com.digiwin.app.dashboard.weather.WeatherConfig;
import com.digiwin.app.module.DWModuleClassLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeatherManager {
    private static Log _log = LogFactory.getLog(WeatherManager.class);
    private static String _CLASSTAG = "[WeatherManager] ";
    private static WeatherConfig weatherConfig;
    private static IWeatherProvider weatherProvider;

    public static IWeatherProvider getProvider() {
        if (weatherProvider != null) {
            return weatherProvider;
        }
        weatherConfig = WeatherConfig.getInstance();
        String baseUrl = weatherConfig.getBaseUrl();
        String providerClassName = weatherConfig.getProviderClassName();
        _log.info((Object)(_CLASSTAG + "weather api url:" + baseUrl));
        try {
            if (!StringUtils.isNotBlank((CharSequence)baseUrl)) {
                _log.info((Object)(_CLASSTAG + "dashBoardWeatherBaseUrl" + " was not setting"));
                throw new DWArgumentException("dashBoardWeatherBaseUrl", "dashBoardWeatherBaseUrl was not setting");
            }
            String moduleName = DWModuleClassLoader.getCurrentModuleName();
            DWModuleClassLoader classLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName((String)moduleName);
            _log.debug((Object)(_CLASSTAG + "creating " + providerClassName));
            Class resolverClass = classLoader.loadClass(providerClassName);
            weatherProvider = (IWeatherProvider)resolverClass.newInstance();
            weatherProvider.setBaseUrl(baseUrl);
            _log.info((Object)(_CLASSTAG + "created " + providerClassName + " successful"));
        }
        catch (Exception e) {
            String message = _CLASSTAG + "created " + providerClassName + " failed";
            _log.error((Object)message, (Throwable)e);
            throw new DWRuntimeException(message, (Throwable)e);
        }
        return weatherProvider;
    }

    public static void setProvider(IWeatherProvider provider) {
        weatherProvider = provider;
    }
}

