/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dashboard.service.impl;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.dashboard.service.IWeatherService;
import com.digiwin.app.dashboard.weather.IWeatherProvider;
import com.digiwin.app.dashboard.weather.WeatherManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

public class WeatherService
implements IWeatherService {
    private static final Log _log = LogFactory.getLog(WeatherService.class);
    private static final String _Key_QueryString = "queryString";
    @Autowired
    private MessageSource messageSource;

    @Override
    public Object get(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        String queryValue = "";
        if (!paramsMap.containsKey(_Key_QueryString)) {
            throw new DWArgumentException(_Key_QueryString, "queryString is not existed!");
        }
        queryValue = (String)paramsMap.get(_Key_QueryString);
        HashMap<String, Exception> returnResult = null;
        boolean success = true;
        try {
            IWeatherProvider provider = WeatherManager.getProvider();
            returnResult = provider.getData(queryValue);
        }
        catch (Exception e) {
            success = false;
            _log.error((Object)"WeatherService", (Throwable)e);
            HashMap<String, Exception> returnData = new HashMap<String, Exception>();
            returnData.put("exception", e);
            returnResult = returnData;
        }
        return DWServiceResultBuilder.build((boolean)success, (String)this.messageSource.getMessage("msg001", null, null), (Object)returnResult);
    }

    private void checkParam(Object params) throws Exception {
        if (params == null) {
            throw new DWArgumentException("params", "params is null!");
        }
    }
}

