
CREATE TABLE IF NOT EXISTS `dw_screen` (
  `screen_id` varchar(200) COLLATE utf8_bin NOT NULL COMMENT '大屏id',
  `screen_name` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '大屏名稱',
  `screen_config` text COLLATE utf8_bin DEFAULT NULL COMMENT '配置',
  `screen_type` varchar(3) COLLATE utf8_bin NOT NULL DEFAULT 'cus' COMMENT '大屏型態',
  `modify_date` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT '最新異動時間',
  PRIMARY KEY (`screen_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='大屏設定主表';

CREATE TABLE IF NOT EXISTS `dw_screen_extra` (
  `screen_id` varchar(200) COLLATE utf8_bin NOT NULL COMMENT '大屏id',
  `screen_default` char(1) COLLATE utf8_bin DEFAULT 'Y' COMMENT '是否為預設大屏, 是:Y',
  PRIMARY KEY (`screen_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin ROW_FORMAT=DYNAMIC COMMENT='大屏進階配置';

CREATE TABLE IF NOT EXISTS `dw_screen_preset` (
  `preset_config` text COLLATE utf8_bin DEFAULT NULL COMMENT '配置'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin ROW_FORMAT=DYNAMIC COMMENT='大屏預設樣式';

CREATE TABLE IF NOT EXISTS `dw_screen_unit` (
  `unit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '應用單元id',
  `screen_id` varchar(200) COLLATE utf8_bin NOT NULL COMMENT '歸屬的大屏id',
  `unit_name` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '應用單元名稱',
  `unit_config` text COLLATE utf8_bin DEFAULT NULL COMMENT '配置',
  `chain_id` varchar(200) COLLATE utf8_bin DEFAULT NULL COMMENT '串接大屏id',
  PRIMARY KEY (`unit_id`,`screen_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin AVG_ROW_LENGTH=1638 COMMENT='大屏應用單元';

INSERT INTO `dw_rdbms_tables` (`table_name`, `table_display_name`, `table_description`) VALUES
	('dw_screen', '大屏設定主表', '大屏設定主表'),
	('dw_screen_extra', '大屏進階配置', '大屏進階配置'),
	('dw_screen_preset', '大屏預設樣式', '大屏預設樣式'),
	('dw_screen_unit', '大屏應用單元', '大屏應用單元')
;

INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES
 	('dw_screen', 1, 'screen_id', 'Y', 'varchar', 'N', 'screen_id', '', '', 'N', 'N', '200', 'N'),
 	('dw_screen', 2, 'screen_name', 'N', 'varchar', 'N', 'screen_name', '', '', 'Y', 'N', '255', 'N'),
 	('dw_screen', 3, 'screen_config', 'N', 'varchar', 'N', 'screen_config', '', '', 'Y', 'N', '2000', 'N'),
 	('dw_screen', 4, 'screen_type', 'N', 'varchar', 'N', 'screen_type', '', '', 'N', 'N', '3', 'N'),
	('dw_screen', 5, 'modify_date', 'N', 'datetime', 'N', 'modify_date', '', '', 'Y', 'N', '20', 'N'),
 	('dw_screen_unit', 1, 'unit_id', 'Y', 'bigint', 'N', 'unit_id', '', '', 'N', 'N', '20', 'Y'),
 	('dw_screen_unit', 2, 'screen_id', 'Y', 'varchar', 'N', 'screen_id', '', '', 'N', 'N', '200', 'N'),
 	('dw_screen_unit', 3, 'unit_name', 'N', 'varchar', 'N', 'unit_name', '', '', 'Y', 'N', '255', 'N'),
 	('dw_screen_unit', 4, 'unit_config', 'N', 'varchar', 'N', 'unit_config', '', '', 'Y', 'N', '2000', 'N'),
	('dw_screen_unit', 5, 'chain_id', 'N', 'varchar', 'N', 'chain_id', '', '', 'Y', 'N', '200', 'N'),
 	('dw_screen_extra', 1, 'screen_id', 'Y', 'varchar', 'N', 'screen_id', '', '', 'N', 'N', '200', 'N'),
 	('dw_screen_extra', 2, 'screen_default', 'N', 'char', 'N', 'screen_default', '', '', 'Y', 'N', '1', 'N'),
	('dw_screen_preset', 1, 'preset_config', 'N', 'varchar', 'N', 'unit_config', '', '', 'Y', 'N', '2000', 'N')
;

INSERT INTO `dw_rdbms_relations` (`PRIMARY_TABLE_NO`, `REFERENCE_TABLE_NO`, `PRIMARY_TABLE_PK`, `REFERENCE_TABLE_PK`) VALUES
	('dw_screen', 'dw_screen_extra', 'screen_id', 'screen_id'),
	('dw_screen', 'dw_screen_unit', 'screen_id', 'screen_id')
;