/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dashboard.service.impl;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.dashboard.service.IScreenService;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.utils.DWTenantUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class ScreenService
implements IScreenService {
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    private MessageSource messageSource;
    private static final String KEY_PARAMS = "params";
    private static final String KEY_MESSAGE_001 = "msg001";
    private static final String MESSAGE_NOT_EXISTED = " is not existed!";
    private static final String SQL_KEYWORD_WHERE = " where ";
    private static final String TAG_TENANT_SID = DWTenantUtils.getTenantTagByColumnName();
    private static final String TAG_IGNORE_TENANT_SID = DWTenantUtils.getTenantIgnoreTagByColumnName();
    private static final String TABLE_MASTER = "dw_screen";
    private static final String TABLE_DETAIL = "dw_screen_unit";
    private static final String TABLE_EXTRA = "dw_screen_extra";
    private static final String TABLE_PRESET = "dw_screen_preset";
    private static final String PARAM_SCREEN = "dw_screen";
    private static final String SCREEN_ID = "screen_id";
    private static final String SCREEN_NAME = "screen_name";
    private static final String SCREEN_MODIFY_DATE = "modify_date";
    private static final String SCREEN_TYPE = "screen_type";
    private static final String KEY_SCREEN_TYPE_STD = "std";
    private static final String PARAM_UNIT = "dw_screen_unit";
    private static final String UNIT_ID = "unit_id";
    private static final String UNIT_NAME = "unit_name";
    private static final String UNIT_CHAIN_ID = "chain_id";
    private static final String EXTRA_SCREEN_DEFAULT = "screen_default";
    private static final String EXTRA_SCREEN_DEFAULT_VALUE = "Y";
    private static final String EXTRA_SCREEN_NOT_DEFAULT_VALUE = "N";
    private static final String PARAM_PRE_SET = "dw_screen_preset";
    private static final String SQL_SCREEN_SERVICE_DELETE_UNITS_BY_SCREEN = " delete from dw_screen_unit where screen_id = ? " + TAG_TENANT_SID + " ";
    private static final String SQL_SCREEN_SERVICE_DELETE_SCREEN_OF_DEFAULT = " delete from dw_screen_extra where screen_default= 'Y' " + TAG_TENANT_SID + " ";
    private static final String SQL_SCREEN_SERVICE_SELECT_SCREEN_OF_CHAIN_ID = " select screen.screen_name, screen.screen_type, unit.screen_id, unit.unit_name, unit.unit_id from dw_screen_unit as unit, dw_screen as screen  where unit.screen_id = screen.screen_id and unit.chain_id =  ? " + TAG_IGNORE_TENANT_SID + " ";
    private static final String SQL_SCREEN_SERVICE_UPDATE_CHAIN_OF_UNIT = " update dw_screen_unit set chain_id = null  where chain_id = ? " + TAG_TENANT_SID + " ";
    private static final String SQL_SCREEN_SERVICE_SELECT_SCREEN = " select * from dw_screen where 1=1 " + TAG_TENANT_SID + " or " + "screen_type" + " = '" + "std" + "' " + " ORDER BY modify_date desc ";

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object post(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        Map screenMap = (Map)paramsMap.get("dw_screen");
        this.checkParam(screenMap, "post");
        screenMap.put("$state", "C");
        String screenId = "";
        String screenType = (String)screenMap.get(SCREEN_TYPE);
        if (!KEY_SCREEN_TYPE_STD.equals(screenType)) {
            screenId = this.genScreenId();
        } else {
            Object screenIdObj = screenMap.get(SCREEN_ID);
            if (screenIdObj != null) {
                screenId = (String)screenMap.get(SCREEN_ID);
            }
            if (StringUtils.isBlank((CharSequence)screenId)) {
                return DWServiceResultBuilder.build((boolean)false, (String)this.messageSource.getMessage("msg011", null, null), (Object)"screen_id format error when screen_type is 'std'");
            }
        }
        screenMap.put(SCREEN_ID, screenId);
        DWDataSet dataset = new DWDataSet();
        DWDataTable screenDWTable = dataset.newTable("dw_screen");
        screenDWTable.newRow(screenMap);
        if (paramsMap.containsKey("dw_screen_unit")) {
            DWDataTable unitDWTable = dataset.newTable("dw_screen_unit");
            List unitListMap = (List)paramsMap.get("dw_screen_unit");
            for (Map unitMap : unitListMap) {
                if (!unitMap.containsKey(SCREEN_ID)) {
                    unitMap.put(SCREEN_ID, screenId);
                }
                DWDataRow unitRow = unitDWTable.newRow(unitMap);
                unitRow.set("$state", (Object)"C");
            }
        }
        DWSQLExecutionResult result = this.dao.execute(dataset);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage(KEY_MESSAGE_001, null, null), (Object)result);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object put(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        Map screenMap = (Map)paramsMap.get("dw_screen");
        String screenId = "";
        if (!screenMap.containsKey(SCREEN_ID)) {
            throw new DWArgumentException(SCREEN_ID, "screen_id is not existed!");
        }
        screenId = screenMap.get(SCREEN_ID);
        LocalDateTime modifyDateTime = LocalDateTime.now();
        screenMap.put(SCREEN_MODIFY_DATE, modifyDateTime);
        DWDataSet dataset = new DWDataSet();
        DWDataTable screenDWTable = dataset.newTable("dw_screen");
        DWDataRow screenRow = screenDWTable.newRow(screenMap);
        screenRow.set("$state", (Object)"U");
        if (paramsMap.containsKey("dw_screen_unit")) {
            DWDataTable unitDWTable = dataset.newTable("dw_screen_unit");
            this.dao.update(SQL_SCREEN_SERVICE_DELETE_UNITS_BY_SCREEN, new Object[]{screenId});
            List unitListMap = (List)paramsMap.get("dw_screen_unit");
            for (Map unitMap : unitListMap) {
                DWDataRow unitRow = unitDWTable.newRow(unitMap);
                unitRow.set(SCREEN_ID, (Object)screenId);
                unitRow.set("$state", (Object)"C");
            }
        }
        DWSQLExecutionResult result = this.dao.execute(dataset);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage(KEY_MESSAGE_001, null, null), (Object)result);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object delete(Object params) throws Exception {
        this.checkParam(params);
        DWSQLExecutionResult result = new DWSQLExecutionResult();
        Map paramsMap = (Map)params;
        if (paramsMap.containsKey(SCREEN_ID)) {
            Object screenId = paramsMap.get(SCREEN_ID);
            DWDataSet dataset = new DWDataSet();
            DWDataTable screenDWTable = dataset.newTable("dw_screen");
            screenDWTable.newRow().set(SCREEN_ID, screenId).set("$state", (Object)"D");
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.addCascadeDeleting("dw_screen", "dw_screen_unit");
            option.addCascadeDeleting("dw_screen", TABLE_EXTRA);
            result = this.dao.execute(dataset, option);
            this.dao.update(SQL_SCREEN_SERVICE_UPDATE_CHAIN_OF_UNIT, new Object[]{screenId});
        }
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage(KEY_MESSAGE_001, null, null), (Object)result);
    }

    @Override
    public Object getList() throws Exception {
        HashMap result = new HashMap();
        ArrayList<Map> resultMaster = new ArrayList<Map>();
        List dwScreenResult = this.dao.select(SQL_SCREEN_SERVICE_SELECT_SCREEN, new Object[0]);
        if (dwScreenResult != null && !dwScreenResult.isEmpty()) {
            DWDataSet datasetExtra = this.getExtra();
            DWDataRowCollection rowCollect = datasetExtra.getTable(TABLE_EXTRA).getRows();
            String screenIdDefault = "";
            String screenIdMaster = "";
            if (rowCollect.size() > 0) {
                DWDataRow defaultrow = rowCollect.get(0);
                screenIdDefault = (String)defaultrow.get(SCREEN_ID);
            }
            List<Object> detailRowList = new ArrayList();
            for (Map masterRow : dwScreenResult) {
                HashMap resultDetail = new HashMap();
                screenIdMaster = (String)masterRow.get(SCREEN_ID);
                if (screenIdDefault != null) {
                    if (screenIdMaster.equals(screenIdDefault)) {
                        masterRow.put(EXTRA_SCREEN_DEFAULT, EXTRA_SCREEN_DEFAULT_VALUE);
                    } else {
                        masterRow.put(EXTRA_SCREEN_DEFAULT, EXTRA_SCREEN_NOT_DEFAULT_VALUE);
                    }
                } else {
                    masterRow.put(EXTRA_SCREEN_DEFAULT, EXTRA_SCREEN_NOT_DEFAULT_VALUE);
                }
                DWDataSet dwScreenDetailResult = this.getDetail(screenIdMaster);
                DWDataRowCollection tempScreenDetail = dwScreenDetailResult.getTable("dw_screen_unit").getRows();
                detailRowList = this.dataTableToList(tempScreenDetail);
                resultDetail.put("dw_screen_unit", detailRowList);
                masterRow.put("child", resultDetail);
                resultMaster.add(masterRow);
            }
        }
        result.put("dw_screen", resultMaster);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage(KEY_MESSAGE_001, null, null), result);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object putDefault(Object params) throws Exception {
        DWSQLExecutionResult result = new DWSQLExecutionResult();
        HashMap paramsMap = params == null ? new HashMap() : (HashMap)params;
        int i = this.dao.update(SQL_SCREEN_SERVICE_DELETE_SCREEN_OF_DEFAULT, new Object[0]);
        if (paramsMap.size() == 0) {
            ArrayList<Integer> sqlresult = new ArrayList<Integer>();
            sqlresult.add(i);
            result.addGeneratedKeys(TABLE_EXTRA, sqlresult);
        } else {
            DWDataSet dataset = new DWDataSet();
            DWDataRow cleanScreenDefaultFlagRow = dataset.newTable(TABLE_EXTRA).newRow();
            cleanScreenDefaultFlagRow.set(SCREEN_ID, paramsMap.get(SCREEN_ID));
            cleanScreenDefaultFlagRow.set("$state", (Object)"C");
            result = this.dao.execute(dataset);
        }
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage(KEY_MESSAGE_001, null, null), (Object)result);
    }

    @Override
    public Object get(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        String screenType = "";
        if (!paramsMap.containsKey(SCREEN_ID)) {
            throw new DWArgumentException(SCREEN_ID, "screen_id is not existed!");
        }
        Object screenId = paramsMap.get(SCREEN_ID);
        screenType = (String)paramsMap.get(SCREEN_TYPE);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_screen");
        queryInfo.addEqualInfo(SCREEN_ID, screenId);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        if (KEY_SCREEN_TYPE_STD.equals(screenType)) {
            option.setTenantEnabled(false);
            queryInfo.addEqualInfo(SCREEN_TYPE, (Object)screenType);
        }
        option.addCascadeQuery("dw_screen", "dw_screen_unit");
        option.addCascadeQuery("dw_screen", TABLE_EXTRA);
        DWDataSet dataset = this.dao.select(queryInfo, option);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage(KEY_MESSAGE_001, null, null), (Object)dataset);
    }

    @Override
    public Object getDefault(Object params) throws Exception {
        this.checkParam(params);
        ArrayList<String> selFileds = new ArrayList<String>();
        selFileds.add(SCREEN_ID);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setSelectFields(selFileds);
        queryInfo.setTableName(TABLE_EXTRA);
        queryInfo.addEqualInfo(EXTRA_SCREEN_DEFAULT, (Object)EXTRA_SCREEN_DEFAULT_VALUE);
        DWDataSet dataset = this.dao.select(queryInfo);
        DWDataRowCollection rowCollect = dataset.getTable(TABLE_EXTRA).getRows();
        DWDataSet datasetMaster = new DWDataSet();
        if (rowCollect.size() > 0) {
            DWDataRow defaultrow = rowCollect.get(0);
            Object screenId = defaultrow.get(SCREEN_ID);
            DWQueryInfo queryInfoMaster = new DWQueryInfo();
            queryInfoMaster.setTableName("dw_screen");
            queryInfoMaster.addEqualInfo(SCREEN_ID, screenId);
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            option.addCascadeQuery("dw_screen", "dw_screen_unit");
            datasetMaster = this.dao.select(queryInfoMaster, option);
        }
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage(KEY_MESSAGE_001, null, null), (Object)datasetMaster);
    }

    private void checkParam(Object params) throws Exception {
        if (params == null) {
            throw new DWArgumentException(KEY_PARAMS, "params is null!");
        }
    }

    private void checkParam(Object obj, String function) throws Exception {
        switch (function) {
            case "post": {
                Map paramsMap;
                if (!(obj instanceof Map) || (paramsMap = (Map)obj).containsKey(SCREEN_TYPE)) break;
                throw new DWArgumentException(KEY_PARAMS, "screen_type is missing!");
            }
            default: {
                if (obj != null) break;
                throw new DWArgumentException(KEY_PARAMS, "params is null!");
            }
        }
    }

    @Override
    public Object getRelation(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        Object screenId = null;
        if (paramsMap.containsKey(SCREEN_ID)) {
            screenId = paramsMap.get(SCREEN_ID);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object chain = this.getChainByScreen(screenId);
        result.put("chain", chain);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage(KEY_MESSAGE_001, null, null), result);
    }

    public Object getChainByScreen(Object screenId) throws Exception {
        return this.dao.select(SQL_SCREEN_SERVICE_SELECT_SCREEN_OF_CHAIN_ID, new Object[]{screenId});
    }

    private DWDataSet getExtra() throws Exception {
        DWQueryInfo queryInfoMaster = new DWQueryInfo();
        queryInfoMaster.setTableName(TABLE_EXTRA);
        return this.dao.select(queryInfoMaster);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object postPreSet(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        Map preSetMap = (Map)paramsMap.get("dw_screen_preset");
        DWDataSet dataset = new DWDataSet();
        DWDataTable screenDWTable = dataset.newTable("dw_screen_preset");
        preSetMap.put("$state", "C");
        screenDWTable.newRow(preSetMap);
        DWSQLExecutionResult result = this.dao.execute(dataset);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage(KEY_MESSAGE_001, null, null), (Object)result);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object putPreSet(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        Map preSetMap = (Map)paramsMap.get("dw_screen_preset");
        DWDataSet dataset = new DWDataSet();
        DWDataTable screenDWTable = dataset.newTable("dw_screen_preset");
        preSetMap.put("$state", "U");
        screenDWTable.newRow(preSetMap);
        DWSQLExecutionResult result = this.dao.execute(dataset);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage(KEY_MESSAGE_001, null, null), (Object)result);
    }

    @Override
    public Object getPreSet() throws Exception {
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_screen_preset");
        DWDataSet dataset = this.dao.select(queryInfo);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage(KEY_MESSAGE_001, null, null), (Object)dataset);
    }

    private String genScreenId() {
        String result = "";
        UUID uuid = UUID.randomUUID();
        result = uuid.toString();
        return result;
    }

    public DWDataSet getDetail(String screenId) throws Exception {
        if (StringUtils.isBlank((CharSequence)screenId)) {
            throw new DWArgumentException(SCREEN_ID, "screen_id is not existed!");
        }
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_screen_unit");
        queryInfo.addEqualInfo(SCREEN_ID, (Object)screenId);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        return this.dao.select(queryInfo, option);
    }

    public List<Map<String, Object>> dataTableToList(DWDataRowCollection dwDataRowCollection) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map rowMap = new HashMap();
        for (DWDataRow dwDataRow : dwDataRowCollection) {
            rowMap = dwDataRow.getData();
            result.add(rowMap);
        }
        return result;
    }
}

