/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dashboard.weather;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.dashboard.weather.IWeatherProvider;
import com.digiwin.app.dashboard.weather.WeatherConfig;
import com.digiwin.app.module.DWModuleClassLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeatherManager {
    private static Log log = LogFactory.getLog(WeatherManager.class);
    private static final String CLASS_TAG = "[WeatherManager] ";
    private static WeatherConfig weatherConfig;
    private static IWeatherProvider weatherProvider;

    WeatherManager() {
    }

    public static IWeatherProvider getProvider() {
        if (weatherProvider != null) {
            return weatherProvider;
        }
        weatherConfig = WeatherConfig.getInstance();
        String baseUrl = weatherConfig.getBaseUrl();
        String providerClassName = weatherConfig.getProviderClassName();
        log.info((Object)("[WeatherManager] weather api url:" + baseUrl));
        try {
            if (!StringUtils.isNotBlank((CharSequence)baseUrl)) {
                log.info((Object)"[WeatherManager] dashBoardWeatherBaseUrl was not setting");
                throw new DWArgumentException("dashBoardWeatherBaseUrl", "dashBoardWeatherBaseUrl was not setting");
            }
            String moduleName = DWModuleClassLoader.getCurrentModuleName();
            DWModuleClassLoader classLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName((String)moduleName);
            log.debug((Object)("[WeatherManager] creating " + providerClassName));
            Class resolverClass = classLoader.loadClass(providerClassName);
            weatherProvider = (IWeatherProvider)resolverClass.newInstance();
            weatherProvider.setBaseUrl(baseUrl);
            log.info((Object)("[WeatherManager] created " + providerClassName + " successful"));
        }
        catch (Exception e) {
            String message = "[WeatherManager] created " + providerClassName + " failed";
            log.error((Object)message, (Throwable)e);
            throw new DWRuntimeException(message, (Throwable)e);
        }
        return weatherProvider;
    }

    public static void setProvider(IWeatherProvider provider) {
        weatherProvider = provider;
    }
}

