/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.permission.controller;

import com.digiwin.app.common.DWResourceUtils;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.data.permission.controller.DWDataPermissionSchemasParameters;
import com.digiwin.data.permission.controller.DWDataPermissionValuesParameters;
import com.digiwin.data.permission.controller.IDWDataPermissionMetadataProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWDataPermissionMetadataJsonFileProvider
implements IDWDataPermissionMetadataProvider {
    public static final String FILE_NAME_SCHEMAS = "data-permission-schemas.json";
    public static final String FILE_NAME_VALUES = "data-permission-values.json";
    private static Log log = LogFactory.getLog(DWDataPermissionMetadataJsonFileProvider.class);

    @Override
    public String getSchema(DWDataPermissionSchemasParameters parameters) {
        String moduleId = parameters.getModuleId();
        String actionId = parameters.getActionId();
        String[] searchKeys = new String[]{moduleId, actionId};
        List<Object> targetActionSchemasList = null;
        try {
            String fileContent = DWResourceUtils.getApplicationResourceString((String)FILE_NAME_SCHEMAS);
            Map metaDataList = (Map)DWGsonProvider.getGson().fromJson(fileContent, Map.class);
            targetActionSchemasList = this.getDetailWithType(metaDataList, searchKeys, (keyIndex, status) -> {
                String errorMessage = "Unknown Error!";
                switch (status) {
                    case 0: {
                        if (keyIndex == 0) {
                            errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getSchema moduleId=%s not found!", moduleId);
                            break;
                        }
                        if (keyIndex != 1) break;
                        errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getSchema actionId=%s not found!", actionId);
                        break;
                    }
                    case 1: {
                        if (keyIndex != 0) break;
                        errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getSchema moduleId=%s is not json object format!", moduleId);
                        break;
                    }
                    case 2: {
                        errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getSchema failed, moduleId=%s actionId=%s is not json array format!", moduleId, actionId);
                    }
                }
                return errorMessage;
            });
        }
        catch (Exception e) {
            log.error((Object)"DWDataPermissionSchemasJsonFileProvidergetSchema failed!", (Throwable)e);
        }
        return targetActionSchemasList == null ? null : DWGsonProvider.getGson().toJson(targetActionSchemasList);
    }

    @Override
    public String getValues(DWDataPermissionValuesParameters parameters) {
        String moduleId = parameters.getModuleId();
        String actionId = parameters.getActionId();
        String tableName = parameters.getTableName();
        String fieldName = parameters.getFieldName();
        String[] searchKeys = new String[]{moduleId, actionId, tableName, fieldName};
        List<Object> targetFieldValuesList = null;
        try {
            String fileContent = DWResourceUtils.getApplicationResourceString((String)FILE_NAME_VALUES);
            Map metaDataList = (Map)DWGsonProvider.getGson().fromJson(fileContent, Map.class);
            targetFieldValuesList = this.getDetailWithType(metaDataList, searchKeys, (keyIndex, status) -> {
                String errorMessage = "Unknown Error!";
                switch (status) {
                    case 0: {
                        if (keyIndex == 0) {
                            errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getValues moduleId=%s not found!", moduleId);
                            break;
                        }
                        if (keyIndex == 1) {
                            errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getValues actionId=%s not found!", actionId);
                            break;
                        }
                        if (keyIndex == 2) {
                            errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getValues tableName=%s not found!", tableName);
                            break;
                        }
                        if (keyIndex != 3) break;
                        errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getValues fieldName=%s not found!", fieldName);
                        break;
                    }
                    case 1: {
                        if (keyIndex == 0) {
                            errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getValues moduleId=%s is not json object format!", moduleId);
                            break;
                        }
                        if (keyIndex == 1) {
                            errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getValues actionId=%s is not json object format!", actionId);
                            break;
                        }
                        if (keyIndex != 2) break;
                        errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getValues tableName=%s is not json object format!", moduleId);
                        break;
                    }
                    case 2: {
                        errorMessage = String.format("DWDataPermissionSchemasJsonFileProvider.getValues failed, moduleId=%s actionId=%s tableName=%s fieldName=% is not json array format!", moduleId, actionId, tableName, fieldName);
                    }
                }
                return errorMessage;
            });
        }
        catch (Exception e) {
            log.error((Object)"DWDataPermissionSchemasJsonFileProvider.getValues failed!", (Throwable)e);
        }
        HashMap<String, Object> finalResult = new HashMap<String, Object>();
        int totalCount = 0;
        List<Object> pageData = null;
        if (targetFieldValuesList != null) {
            totalCount = targetFieldValuesList.size();
            int pageSize = parameters.getPageSize();
            int pageNumber = parameters.getPageNum();
            if (pageSize < 0) {
                pageSize = 0;
            }
            if (pageNumber < 0) {
                pageNumber = 0;
            }
            int pageStartIndex = (pageNumber - 1) * pageSize;
            int pageToIndex = pageStartIndex + pageSize;
            if (pageStartIndex <= targetFieldValuesList.size() - 1) {
                if (pageToIndex > targetFieldValuesList.size()) {
                    pageToIndex = targetFieldValuesList.size();
                }
                pageData = targetFieldValuesList.subList(pageStartIndex, pageToIndex);
            }
        }
        finalResult.put("total", totalCount);
        finalResult.put("items", pageData);
        return DWGsonProvider.getGson().toJson(finalResult);
    }

    private List<Object> getDetailWithType(Map<String, Object> data, String[] searchKeys, BiFunction<Integer, Byte, String> errorMessageProvider) {
        return this.getDetailWithType(data, searchKeys, 0, errorMessageProvider);
    }

    private List<Object> getDetailWithType(Map<String, Object> data, String[] searchKeys, int searchIndex, BiFunction<Integer, Byte, String> errorMessageProvider) {
        String targetKey = searchKeys[searchIndex];
        Map.Entry targetDetailItem = data.entrySet().stream().filter(item -> targetKey.equalsIgnoreCase((String)item.getKey())).findFirst().orElse(null);
        if (targetDetailItem == null) {
            log.warn((Object)errorMessageProvider.apply(searchIndex, (byte)0));
            return null;
        }
        Object targetDetail = targetDetailItem.getValue();
        if (searchIndex == searchKeys.length - 1) {
            if (targetDetail instanceof List) {
                return (List)targetDetail;
            }
            log.error((Object)errorMessageProvider.apply(searchIndex, (byte)2));
            return null;
        }
        if (targetDetail instanceof Map) {
            return this.getDetailWithType((Map)targetDetail, searchKeys, ++searchIndex, errorMessageProvider);
        }
        log.error((Object)errorMessageProvider.apply(searchIndex, (byte)1));
        return null;
    }
}

