/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.permission.row.condition;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.data.permission.DWPermissionCondition;
import com.digiwin.data.permission.DWPermissionOperator;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DWPermissionBetweenCondition
extends DWPermissionCondition {
    @Override
    protected boolean isSupport(DWPermissionOperator operator) {
        return operator == DWPermissionOperator.Between;
    }

    @Override
    protected boolean matchCore(Object data, DWPermissionOperator operator, List<? extends Object> conditionValues) {
        if (conditionValues == null || conditionValues.isEmpty()) {
            throw new IllegalArgumentException("filter value is null or empty");
        }
        if (conditionValues.size() > 1) {
            throw new IllegalArgumentException("fiter value arrays length is more than one, must be one");
        }
        return true;
    }

    @Override
    protected DWSqlInfo getSQLCore(String fieldName, DWPermissionOperator operator, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        ArrayList params = new ArrayList();
        Map conditionValue = (Map)conditionValues.get(0);
        StringBuilder sql = new StringBuilder();
        sql.append("( ");
        boolean closeMin = (Boolean)conditionValue.get("closeMin");
        if (closeMin) {
            sql.append(fieldName + " >= ?");
        } else {
            sql.append(fieldName + " > ?");
        }
        boolean closeMax = (Boolean)conditionValue.get("closeMax");
        if (closeMax) {
            sql.append(" and " + fieldName + " <= ?");
        } else {
            sql.append(" and " + fieldName + " < ?");
        }
        sql.append(") ");
        params.add(conditionValue.get("min"));
        params.add(conditionValue.get("max"));
        return new DWSqlInfo(sql.toString(), Arrays.asList(params));
    }

    @Override
    protected String getSQLContainValuesCore(String fieldName, DWPermissionOperator operator, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        ArrayList params = new ArrayList();
        Map conditionValue = (Map)conditionValues.get(0);
        StringBuilder sql = new StringBuilder();
        sql.append("( ");
        boolean closeMin = (Boolean)conditionValue.get("closeMin");
        if (closeMin) {
            sql.append(fieldName + " >= " + String.valueOf(conditionValue.get("min")));
        } else {
            sql.append(fieldName + " > " + String.valueOf(conditionValue.get("min")));
        }
        boolean closeMax = (Boolean)conditionValue.get("closeMax");
        if (closeMax) {
            sql.append(" and " + fieldName + " <= " + String.valueOf(conditionValue.get("max")));
        } else {
            sql.append(" and " + fieldName + " < " + String.valueOf(conditionValue.get("max")));
        }
        sql.append(") ");
        params.add(conditionValue.get("min"));
        params.add(conditionValue.get("max"));
        return sql.toString();
    }

    @Override
    protected DWQueryCondition getQueryConditionCore(String fieldName, DWPermissionOperator operator, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        Map conditionValue = (Map)conditionValues.get(0);
        DWQueryCondition queryCondition = new DWQueryCondition();
        DWQueryCondition minCondition = new DWQueryCondition();
        DWQueryCondition maxCondition = new DWQueryCondition();
        boolean closeMin = (Boolean)conditionValue.get("closeMin");
        if (closeMin) {
            minCondition.addFieldInfo(fieldName, DWQueryValueOperator.GreaterThanOrEqualTo, new Object[]{conditionValue.get("min")});
        } else {
            minCondition.addFieldInfo(fieldName, DWQueryValueOperator.GreaterThan, new Object[]{conditionValue.get("min")});
        }
        boolean closeMax = (Boolean)conditionValue.get("closeMax");
        if (closeMax) {
            maxCondition.addFieldInfo(fieldName, DWQueryValueOperator.LessThanOrEqualTo, new Object[]{conditionValue.get("max")});
        } else {
            maxCondition.addFieldInfo(fieldName, DWQueryValueOperator.LessThan, new Object[]{conditionValue.get("max")});
        }
        queryCondition.addCondition(minCondition);
        queryCondition.addCondition(maxCondition);
        return queryCondition;
    }
}

