/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.agent.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;

public class CommonUtils {
    public static byte[] loadFromURI(String uri) throws IOException {
        String uriWithoutScheme = uri.replace("file:///", "");
        File file = new File(uriWithoutScheme);
        byte[] data = new byte[(int)file.length()];
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        dis.readFully(data);
        dis.close();
        return data;
    }

    public static String convertFileNameToQualifiedName(List<String> hotLoadingPaths, String fileName) {
        String className = fileName.replace("file:///", "").replace("\\", "/");
        for (String hotLoadingPath : hotLoadingPaths) {
            String hotLoadPathReplacedSlash = hotLoadingPath.replace("\\", "/") + "/";
            className = className.replace(hotLoadPathReplacedSlash, "");
        }
        className = className.replace("/", ".").replace(".class", "");
        return className;
    }

    public static String[] convertFileNameToModuleNameAndQualifiedName(List<String> hotLoadingPaths, String fileName) {
        String[] result = new String[2];
        String fileNameReplaced = fileName.replace("file:///", "").replace("\\", "/");
        for (String hotLoadingPath : hotLoadingPaths) {
            String hotLoadingPathReplacedSlash = hotLoadingPath.replace("\\", "/") + "/";
            fileNameReplaced = fileNameReplaced.replace(hotLoadingPathReplacedSlash, "");
        }
        fileNameReplaced = fileNameReplaced.replace("/", ".").replace(".class", "");
        int firstDotIndex = fileNameReplaced.indexOf(".");
        result[0] = fileNameReplaced.substring(0, firstDotIndex);
        result[1] = fileNameReplaced.substring(firstDotIndex + 1, fileNameReplaced.length());
        return result;
    }
}

