/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.util;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.util.DocumentIdFinder;
import com.digiwin.util.DocumentIdFormatter;
import com.digiwin.util.DocumentIdSetting;
import com.digiwin.utils.DWTenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentIdGenerator {
    private static final Log logger = LogFactory.getLog(DocumentIdGenerator.class);
    private DocumentIdFormatter formatter = new DocumentIdFormatter();
    @Autowired
    private DocumentIdFinder finder;
    @Autowired
    private DWRedisService redisTemplate;
    private String redisPrefixFolder = "DAP:DocumentId";

    public String getId(DocumentIdSetting setting) throws Exception {
        if (setting != null && setting.getNumber() > 1) {
            throw new DWDataException("setting.setNumber can't greater than 1");
        }
        String result = this.generateId(setting).get(0);
        return result;
    }

    public List<String> getIdList(DocumentIdSetting setting) throws Exception {
        List<String> result = this.generateId(setting);
        return result;
    }

    private List<String> generateId(DocumentIdSetting setting) throws Exception {
        if (setting == null) {
            throw new DWDataException("DocumentIdSetting can'n be null ");
        }
        ArrayList<String> result = new ArrayList<String>();
        String group = this.formatter.format(setting);
        logger.debug((Object)("group:" + group));
        List<Long> serialIds = this.generateSerialId(group, setting);
        for (long serialId : serialIds) {
            result.add(this.formatter.format(group, serialId, setting.getSerialIdLength()));
            logger.debug((Object)("serialId:" + serialId));
        }
        return result;
    }

    private List<Long> generateSerialId(String group, DocumentIdSetting setting) throws Exception {
        long startId;
        ArrayList<Long> result = new ArrayList<Long>();
        StringBuilder redisKeyGroup = new StringBuilder();
        String appId = DWApplicationConfigUtils.getProperty((String)"appId");
        redisKeyGroup.append(this.redisPrefixFolder).append(":").append(appId).append(":");
        if (setting.isTenant()) {
            Map profile = DWServiceContext.getContext().getProfile();
            redisKeyGroup.append(profile.get(DWTenantUtils.getIAMTenantSidKey())).append(":");
        }
        redisKeyGroup.append(group);
        if (!this.redisTemplate.hasKey(redisKeyGroup.toString()).booleanValue()) {
            int maxSeriaNo = 0;
            String documentId = this.finder.getMaxSerialNo(group, setting);
            if (documentId != null && !documentId.equals("")) {
                maxSeriaNo = this.formatter.fetchSerialNo(documentId, group, setting.getSerialIdLength());
            }
            this.redisTemplate.set(redisKeyGroup.toString(), (Object)maxSeriaNo);
        }
        long currentId = this.redisTemplate.incrBy(redisKeyGroup.toString(), (long)setting.getNumber());
        for (long i = startId = currentId - (long)setting.getNumber() + 1L; i <= currentId; ++i) {
            result.add(i);
            logger.debug((Object)("Fetch redis serialNo=" + i));
        }
        return result;
    }
}

