/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.util;

import com.digiwin.util.DocumentIdSetting;
import java.util.regex.Pattern;

public class DocumentIdFormatter {
    public String format(DocumentIdSetting setting) throws Exception {
        StringBuilder result = new StringBuilder();
        String strYear = String.valueOf(setting.getYear());
        String strMonth = this.formatMonth(setting.getMonth());
        String strDay = this.formatDay(setting.getDay());
        result.append(setting.getPrefix()).append(strYear).append(strMonth).append(strDay);
        return result.toString();
    }

    public String format(String group, long serialId, int serialIdLength) throws Exception {
        StringBuilder result = new StringBuilder();
        String strSerialId = this.formatSerialId(serialIdLength, serialId);
        result.append(group + strSerialId);
        return result.toString();
    }

    public int fetchSerialNo(String documentId, String group, int serialIdLength) throws Exception {
        String strSerialNo = documentId.substring(group.length());
        Pattern pattern = Pattern.compile("[0-9]*");
        boolean isInteger = pattern.matcher(strSerialNo).matches();
        if (!isInteger) {
            strSerialNo = this.formatSerialId(serialIdLength, 0L);
        }
        return Integer.parseInt(strSerialNo);
    }

    private String formatMonth(int month) throws Exception {
        return String.format("%02d", month);
    }

    private String formatDay(int day) throws Exception {
        return String.format("%02d", day);
    }

    private String formatSerialId(int serialIdLength, long serialId) throws Exception {
        return String.format("%0" + serialIdLength + "d", serialId);
    }
}

