/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.eai.DigiHost;
import com.digiwin.app.eai.DigiProtocol;
import com.digiwin.app.eai.DigiService;
import com.digiwin.app.eai.DigiType;
import com.digiwin.app.eai.util.MD5;
import com.digiwin.app.service.DWServiceContext;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.json.JSONObject;

public class DWEAI {
    private static final String CONTENT_TYPE = "application/json; charset=utf-8";
    private static CloseableHttpClient httpClient;
    private DigiType digiType;
    private DigiProtocol digiProtocol;
    private DigiHost digiHost;
    private DigiService digiService;
    private Map<String, Object> parameter;
    private String digiDatakey;
    private String callback;
    private Map<String, String> customHeader;
    private Map<String, String> customCallbackHeader;

    public DWEAI(DigiType digiType, DigiProtocol digiProtocol, DigiHost digiHost, DigiService digiService, Map<String, Object> parameter) {
        this.digiType = digiType;
        this.digiProtocol = digiProtocol;
        this.digiHost = digiHost;
        this.digiService = digiService;
        this.parameter = parameter;
        this.customHeader = new HashMap<String, String>();
        this.customCallbackHeader = new HashMap<String, String>();
    }

    public Map<String, Object> execute() throws Exception {
        if (this.digiProtocol.equals((Object)DigiProtocol.ftp) && !this.digiType.equals((Object)DigiType.async)) {
            throw new IllegalStateException("DigiProtocol = ftp, DigiType must be async!!");
        }
        if (this.digiProtocol.equals((Object)DigiProtocol.serial)) {
            if (!this.parameter.containsKey("zip_data")) {
                throw new IllegalStateException("parameter must contain key - zip_data");
            }
            if (!this.parameter.containsKey("file_name")) {
                throw new IllegalStateException("parameter must contain key - file_name");
            }
        }
        if (this.digiProtocol.equals((Object)DigiProtocol.ftp)) {
            if (!this.parameter.containsKey("zip_path")) {
                throw new IllegalStateException("parameter must contain key - zip_path");
            }
            if (!this.parameter.containsKey("file_name")) {
                throw new IllegalStateException("parameter must contain key - file_name");
            }
        }
        HttpPost httpPost = this.getHttpPost();
        Map<String, Object> result = this.executeHttpRequest(httpPost);
        return result;
    }

    private HttpPost getHttpPost() throws Exception {
        String value;
        String key;
        String url = DWApplicationConfigUtils.getProperty((String)"eaiUrl");
        HttpPost httpPost = new HttpPost(url + "/CROSS/RESTful");
        httpPost.addHeader("Content-Type", CONTENT_TYPE);
        httpPost.addHeader("digi-type", this.digiType.value());
        httpPost.addHeader("digi-protocol", this.digiProtocol.value());
        String digiHostJson = this.digiHost.toJSON();
        httpPost.addHeader("digi-host", this.digiHost.toJSON());
        String digiServiceJson = this.digiService.toJSON();
        httpPost.addHeader("digi-service", digiServiceJson);
        String token = DWServiceContext.getContext().getToken();
        if (!StringUtils.isBlank((CharSequence)token)) {
            httpPost.addHeader("digi-token", token);
        }
        String digiKey = MD5.generate(digiHostJson + digiServiceJson).toUpperCase();
        httpPost.addHeader("digi-key", digiKey);
        if (!StringUtils.isBlank((CharSequence)this.digiDatakey)) {
            httpPost.addHeader("digi-datakey", this.digiDatakey);
        }
        if (DigiType.async.equals((Object)this.digiType)) {
            if (StringUtils.isBlank((CharSequence)token)) {
                token = "";
            }
            httpPost.addHeader("digi-callback-token", token);
            httpPost.addHeader("digi-callback-callback", this.callback);
        }
        for (Map.Entry<String, String> entry : this.customHeader.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith("digi-")) {
                httpPost.addHeader(key, value);
                continue;
            }
            httpPost.addHeader("digi-" + key, value);
        }
        for (Map.Entry<String, String> entry : this.customCallbackHeader.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith("digi-callback-")) {
                httpPost.addHeader(key, value);
                continue;
            }
            httpPost.addHeader("digi-callback-" + key, value);
        }
        StringEntity stringEntity = new StringEntity("", StandardCharsets.UTF_8);
        switch (this.digiProtocol) {
            case raw: {
                JSONObject parameterJo = new JSONObject();
                parameterJo.put("parameter", (Object)new JSONObject(this.parameter));
                JSONObject stdDataJo = new JSONObject();
                stdDataJo.put("std_data", (Object)parameterJo);
                stringEntity = new StringEntity(stdDataJo.toString(), StandardCharsets.UTF_8);
                break;
            }
            case serial: {
                JSONObject serialBody = new JSONObject(this.parameter);
                stringEntity = new StringEntity(serialBody.toString(), StandardCharsets.UTF_8);
                break;
            }
            case ftp: {
                JSONObject ftpBody = new JSONObject(this.parameter);
                stringEntity = new StringEntity(ftpBody.toString(), StandardCharsets.UTF_8);
            }
        }
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    private Map<String, Object> executeHttpRequest(HttpPost httpPost) throws Exception {
        JSONObject responseJo = new JSONObject();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            JSONObject headerJo = new JSONObject();
            List<Header> headers = Arrays.asList(response.getAllHeaders());
            for (Object header : headers) {
                if (!header.getName().startsWith("digi-")) continue;
                if ("digi-message".equalsIgnoreCase(header.getName())) {
                    headerJo.put(header.getName(), (Object)new String(Base64.getDecoder().decode(header.getValue()), StandardCharsets.UTF_8));
                    continue;
                }
                headerJo.put(header.getName(), (Object)header.getValue());
            }
            responseJo.put("headers", (Object)headerJo);
            InputStream content = response.getEntity().getContent();
            if (content == null) {
                Object header;
                responseJo.put("messageBody", (Object)"");
                header = responseJo.toMap();
                return header;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(content, StandardCharsets.UTF_8);
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                StringBuffer stringBuffer = new StringBuffer("");
                String line = "";
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuffer.append(line);
                }
                responseJo.put("messageBody", (Object)stringBuffer.toString());
            }
        }
        return responseJo.toMap();
    }

    public void setDigiDatakey(String digiDatakey) {
        this.digiDatakey = digiDatakey;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public void setCustomHeader(Map<String, String> customHeader) {
        this.customHeader = customHeader;
    }

    public void setCustomCallbackHeader(Map<String, String> customCallbackHeader) {
        this.customCallbackHeader = customCallbackHeader;
    }

    static {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(500);
        manager.setDefaultMaxPerRoute(500);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
        IdleConnectionMonitorThread monitor = new IdleConnectionMonitorThread((HttpClientConnectionManager)manager);
        monitor.start();
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager manager;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager manager) {
            this.manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.manager.closeExpiredConnections();
                        this.manager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                this.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

